/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestResponseMapping;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.mapping.Scenario;
import com.github.tomakehurst.wiremock.mapping.SortedConcurrentMappingSet;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryMappings
implements Mappings {
    private final SortedConcurrentMappingSet mappings = new SortedConcurrentMappingSet();
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();

    @Override
    public ResponseDefinition serveFor(Request request) {
        RequestResponseMapping matchingMapping = (RequestResponseMapping)Iterables.find((Iterable)this.mappings, this.mappingMatchingAndInCorrectScenarioState(request), (Object)RequestResponseMapping.NOT_CONFIGURED);
        this.notifyIfResponseNotConfigured(request, matchingMapping);
        matchingMapping.updateScenarioStateIfRequired();
        return ResponseDefinition.copyOf(matchingMapping.getResponse());
    }

    private void notifyIfResponseNotConfigured(Request request, RequestResponseMapping matchingMapping) {
        if (matchingMapping == RequestResponseMapping.NOT_CONFIGURED) {
            LocalNotifier.notifier().info("No mapping found matching URL " + request.getUrl());
        }
    }

    @Override
    public void addMapping(RequestResponseMapping mapping) {
        if (mapping.isInScenario()) {
            this.scenarioMap.putIfAbsent(mapping.getScenarioName(), Scenario.inStartedState());
            Scenario scenario = this.scenarioMap.get(mapping.getScenarioName());
            mapping.setScenario(scenario);
        }
        this.mappings.add(mapping);
    }

    @Override
    public void reset() {
        this.mappings.clear();
        this.scenarioMap.clear();
    }

    @Override
    public void resetScenarios() {
        for (Scenario scenario : this.scenarioMap.values()) {
            scenario.reset();
        }
    }

    private Predicate<RequestResponseMapping> mappingMatchingAndInCorrectScenarioState(final Request request) {
        return new Predicate<RequestResponseMapping>(){

            public boolean apply(RequestResponseMapping mapping) {
                return mapping.getRequest().isMatchedBy(request) && (mapping.isIndependentOfScenarioState() || mapping.requiresCurrentScenarioState());
            }
        };
    }
}

