/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.google.common.base.Optional;

public class ContentTypeHeader
extends HttpHeader {
    public static final String KEY = "Content-Type";
    private String[] parts;

    public static Optional<ContentTypeHeader> getFrom(Request request) {
        String value = request.getHeader(KEY);
        if (value != null) {
            return Optional.of((Object)new ContentTypeHeader(value));
        }
        return Optional.absent();
    }

    public ContentTypeHeader(String stringValue) {
        super(KEY, stringValue);
        this.parts = stringValue.split(";");
    }

    public static ContentTypeHeader absent() {
        return new ContentTypeHeader();
    }

    private ContentTypeHeader() {
        super(KEY, (String[])null);
    }

    public String mimeTypePart() {
        return this.parts[0];
    }

    public Optional<String> encodingPart() {
        if (this.parts.length < 2) {
            return Optional.absent();
        }
        return Optional.of((Object)this.parts[1].split("=")[1]);
    }
}

