/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import java.lang.reflect.Field;
import java.net.Socket;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.HttpConnection;

public class ServletContainerUtils {
    public static Socket getUnderlyingSocketFrom(HttpServletResponse httpServletResponse) {
        HttpConnection httpConnection = (HttpConnection)ServletContainerUtils.getPrivateField(httpServletResponse, "_connection");
        EndPoint channelEndPoint = httpConnection.getEndPoint();
        return (Socket)ServletContainerUtils.getPrivateField(channelEndPoint, "_socket");
    }

    public static boolean isBrowserProxyRequest(HttpServletRequest request) {
        if (!ServletContainerUtils.hasField(request, "_uri")) {
            return false;
        }
        String uriString = ServletContainerUtils.getPrivateField(request, "_uri").toString();
        URI uri = URI.create(uriString);
        return uri.isAbsolute();
    }

    private static <T> T getPrivateField(Object obj, String name) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasField(Object obj, String name) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            return field != null;
        }
        catch (RuntimeException re) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

