/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.Collection;
import java.util.stream.Stream;
import wiremock.net.javacrumbs.jsonunit.core.Option;
import wiremock.net.javacrumbs.jsonunit.core.internal.PathMatcher;
import wiremock.net.javacrumbs.jsonunit.core.internal.PathOption;

class PathOptionMatcher {
    private final PathMatcher pathMatcher;
    private final Option option;
    private final boolean added;

    private PathOptionMatcher(Collection<String> paths, Option option, boolean added) {
        this.pathMatcher = PathMatcher.create(paths);
        this.option = option;
        this.added = added;
    }

    static Stream<PathOptionMatcher> createMatchersFromPathOption(PathOption pathOption) {
        return pathOption.getOptions().stream().map(option -> new PathOptionMatcher((Collection<String>)pathOption.getPaths(), (Option)((Object)option), pathOption.isIncluded()));
    }

    public boolean matches(String path) {
        return this.pathMatcher.matches(path);
    }

    public Option getOption() {
        return this.option;
    }

    boolean isAdded() {
        return this.added;
    }
}

