/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpEntity;
import wiremock.org.apache.hc.core5.http.ParseException;
import wiremock.org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static String getEntityAsStringAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                String content = EntityUtils.toString(entity, StandardCharsets.UTF_8);
                entity.getContent().close();
                return content;
            }
            catch (IOException | ParseException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }

    public static byte[] getEntityAsByteArrayAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                byte[] content = EntityUtils.toByteArray(entity);
                entity.getContent().close();
                return content;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }
}

