/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.graph;

import wiremock.com.google.common.annotations.Beta;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Functions;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.graph.AbstractGraphBuilder;
import wiremock.com.google.common.graph.ConfigurableValueGraph;
import wiremock.com.google.common.graph.DirectedGraphConnections;
import wiremock.com.google.common.graph.ForwardingGraph;
import wiremock.com.google.common.graph.Graph;
import wiremock.com.google.common.graph.GraphBuilder;
import wiremock.com.google.common.graph.GraphConnections;
import wiremock.com.google.common.graph.GraphConstants;
import wiremock.com.google.common.graph.UndirectedGraphConnections;
import wiremock.com.google.common.graph.ValueGraph;

@Beta
public abstract class ImmutableGraph<N>
extends ForwardingGraph<N> {
    ImmutableGraph() {
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ValueBackedImpl<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size());
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    static class ValueBackedImpl<N, V>
    extends ImmutableGraph<N> {
        protected final ValueGraph<N, V> backingValueGraph;

        ValueBackedImpl(AbstractGraphBuilder<? super N> builder, ImmutableMap<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
            this.backingValueGraph = new ConfigurableValueGraph<N, V>(builder, nodeConnections, edgeCount);
        }

        @Override
        protected Graph<N> delegate() {
            return this.backingValueGraph;
        }
    }
}

