/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.jayway.jsonpath.Filter;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.Predicate;
import wiremock.com.jayway.jsonpath.internal.Cache;
import wiremock.com.jayway.jsonpath.internal.CompiledPath;
import wiremock.com.jayway.jsonpath.internal.Path;
import wiremock.com.jayway.jsonpath.internal.Utils;
import wiremock.com.jayway.jsonpath.internal.token.ArrayPathToken;
import wiremock.com.jayway.jsonpath.internal.token.PathToken;
import wiremock.com.jayway.jsonpath.internal.token.PredicatePathToken;
import wiremock.com.jayway.jsonpath.internal.token.PropertyPathToken;
import wiremock.com.jayway.jsonpath.internal.token.RootPathToken;
import wiremock.com.jayway.jsonpath.internal.token.ScanPathToken;
import wiremock.com.jayway.jsonpath.internal.token.WildcardPathToken;

public class PathCompiler {
    private static final Logger logger = LoggerFactory.getLogger(PathCompiler.class);
    private static final String PROPERTY_OPEN = "['";
    private static final String PROPERTY_CLOSE = "']";
    private static final char DOCUMENT = '$';
    private static final char ANY = '*';
    private static final char PERIOD = '.';
    private static final char BRACKET_OPEN = '[';
    private static final char BRACKET_CLOSE = ']';
    private static final char SPACE = ' ';
    private static final Cache cache = new Cache(200);

    public static Path compile(String path, Predicate ... filters) {
        Utils.notEmpty(path, "Path may not be null empty", new Object[0]);
        try {
            boolean isRootPath;
            path = path.trim();
            if (path.endsWith("..")) {
                throw new InvalidPathException("A path can not end with a scan.");
            }
            LinkedList<Predicate> filterList = new LinkedList<Predicate>(Arrays.asList(filters));
            if (path.charAt(0) != '$' && path.charAt(0) != '@') {
                path = "$." + path;
            }
            boolean bl = isRootPath = path.charAt(0) == '$';
            if (path.charAt(0) == '@') {
                path = "$" + path.substring(1);
            }
            if (path.length() > 1 && path.charAt(1) != '.' && path.charAt(1) != '[') {
                throw new InvalidPathException("Invalid path " + path);
            }
            String cacheKey = path + isRootPath + filterList.toString();
            Path p = cache.get(cacheKey);
            if (p != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Using cached path: " + cacheKey);
                }
                return p;
            }
            RootPathToken root = null;
            int i = 0;
            String fragment = "";
            block9: do {
                char current = path.charAt(i);
                switch (current) {
                    case ' ': {
                        throw new InvalidPathException("Space not allowed in path");
                    }
                    case '$': {
                        fragment = "$";
                        ++i;
                        break;
                    }
                    case '[': {
                        int positions = PathCompiler.fastForwardUntilClosed(path, i);
                        fragment = path.substring(i, i + positions);
                        i += positions;
                        break;
                    }
                    case '.': {
                        if (path.charAt(++i) == '.') {
                            fragment = "..";
                            ++i;
                            break;
                        }
                        int positions = PathCompiler.fastForward(path, i);
                        if (positions == 0) continue block9;
                        if (positions == 1 && path.charAt(i) == '*') {
                            fragment = new String("[*]");
                        } else {
                            PathCompiler.assertValidFieldChars(path, i, positions);
                            fragment = PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                        }
                        i += positions;
                        break;
                    }
                    case '*': {
                        fragment = new String("[*]");
                        ++i;
                        break;
                    }
                    default: {
                        int positions = PathCompiler.fastForward(path, i);
                        fragment = PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                        i += positions;
                    }
                }
                if (root == null) {
                    root = (RootPathToken)PathComponentAnalyzer.analyze(fragment, filterList);
                    continue;
                }
                root.append(PathComponentAnalyzer.analyze(fragment, filterList));
            } while (i < path.length());
            CompiledPath pa = new CompiledPath(root, isRootPath);
            cache.put(cacheKey, pa);
            return pa;
        }
        catch (Exception ex) {
            throw new InvalidPathException(ex);
        }
    }

    private static void assertValidFieldChars(String s, int start, int positions) {
    }

    private static int fastForward(String s, int index) {
        char current;
        int skipCount = 0;
        while (index < s.length() && (current = s.charAt(index)) != '.' && current != '[' && current != ' ') {
            ++index;
            ++skipCount;
        }
        return skipCount;
    }

    private static int fastForwardUntilClosed(String s, int index) {
        int skipCount = 0;
        int nestedBrackets = 0;
        ++index;
        ++skipCount;
        while (index < s.length()) {
            char current = s.charAt(index);
            ++index;
            ++skipCount;
            if (current == ']' && nestedBrackets == 0) break;
            if (current == '[') {
                ++nestedBrackets;
            }
            if (current != ']') continue;
            --nestedBrackets;
        }
        return skipCount;
    }

    static class PathComponentAnalyzer {
        private static final Pattern FILTER_PATTERN = Pattern.compile("^\\[\\s*\\?\\s*[,\\s*\\?]*?\\s*]$");
        private int i;
        private char current;
        private final LinkedList<Predicate> filterList;
        private final String pathFragment;

        PathComponentAnalyzer(String pathFragment, LinkedList<Predicate> filterList) {
            this.pathFragment = pathFragment;
            this.filterList = filterList;
        }

        static PathToken analyze(String pathFragment, LinkedList<Predicate> filterList) {
            return new PathComponentAnalyzer(pathFragment, filterList).analyze();
        }

        public PathToken analyze() {
            if ("$".equals(this.pathFragment)) {
                return new RootPathToken();
            }
            if ("..".equals(this.pathFragment)) {
                return new ScanPathToken();
            }
            if ("[*]".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if (".*".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if ("[?]".equals(this.pathFragment)) {
                return new PredicatePathToken(this.filterList.poll());
            }
            if (FILTER_PATTERN.matcher(this.pathFragment).matches()) {
                int criteriaCount = Utils.countMatches(this.pathFragment, "?");
                ArrayList<Predicate> filters = new ArrayList<Predicate>(criteriaCount);
                for (int i = 0; i < criteriaCount; ++i) {
                    filters.add(this.filterList.poll());
                }
                return new PredicatePathToken(filters);
            }
            this.i = 0;
            do {
                this.current = this.pathFragment.charAt(this.i);
                switch (this.current) {
                    case '?': {
                        return this.analyzeCriteriaSequence4();
                    }
                    case '\'': {
                        return this.analyzeProperty();
                    }
                }
                if (Character.isDigit(this.current) || this.current == ':' || this.current == '-' || this.current == '@') {
                    return this.analyzeArraySequence();
                }
                ++this.i;
            } while (this.i < this.pathFragment.length());
            throw new InvalidPathException("Could not analyze path component: " + this.pathFragment);
        }

        public PathToken analyzeCriteriaSequence4() {
            int[] bounds = this.findFilterBounds();
            this.i = bounds[1];
            return new PredicatePathToken(Filter.parse(this.pathFragment.substring(bounds[0], bounds[1])));
        }

        int[] findFilterBounds() {
            int end = 0;
            int start = this.i;
            while (this.pathFragment.charAt(start) != '[') {
                --start;
            }
            int mem = 32;
            int curr = start;
            boolean inProp = false;
            int openSquareBracket = 0;
            int openBrackets = 0;
            while (end == 0) {
                char c = this.pathFragment.charAt(curr);
                switch (c) {
                    case '(': {
                        if (inProp) break;
                        ++openBrackets;
                        break;
                    }
                    case ')': {
                        if (inProp) break;
                        --openBrackets;
                        break;
                    }
                    case '[': {
                        if (inProp) break;
                        ++openSquareBracket;
                        break;
                    }
                    case ']': {
                        if (inProp) break;
                        --openSquareBracket;
                        if (openBrackets != 0) break;
                        end = curr + 1;
                        break;
                    }
                    case '\'': {
                        if (mem == 92) break;
                        inProp = !inProp;
                        break;
                    }
                }
                mem = c;
                ++curr;
            }
            if (openBrackets != 0 || openSquareBracket != 0) {
                throw new InvalidPathException("Filter brackets are not balanced");
            }
            return new int[]{start, end};
        }

        private PathToken analyzeProperty() {
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            boolean propertyIsOpen = false;
            while (this.current != ']') {
                switch (this.current) {
                    case '\'': {
                        if (propertyIsOpen) {
                            properties.add(buffer.toString());
                            buffer.setLength(0);
                            propertyIsOpen = false;
                            break;
                        }
                        propertyIsOpen = true;
                        break;
                    }
                    default: {
                        if (!propertyIsOpen) break;
                        buffer.append(this.current);
                    }
                }
                this.current = this.pathFragment.charAt(++this.i);
            }
            return new PropertyPathToken(properties);
        }

        private PathToken analyzeArraySequence() {
            StringBuilder buffer = new StringBuilder();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            boolean contextSize = this.current == '@';
            boolean sliceTo = false;
            boolean sliceFrom = false;
            boolean sliceBetween = false;
            boolean indexSequence = false;
            boolean singleIndex = false;
            if (contextSize) {
                this.current = this.pathFragment.charAt(++this.i);
                this.current = this.pathFragment.charAt(++this.i);
                while (this.current != '-') {
                    if (this.current == ' ' || this.current == '(' || this.current == ')') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
                String function = buffer.toString();
                buffer.setLength(0);
                if (!function.equals("size") && !function.equals("length")) {
                    throw new InvalidPathException("Invalid function: @." + function + ". Supported functions are: [(@.length - n)] and [(@.size() - n)]");
                }
                while (this.current != ')') {
                    if (this.current == ' ') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
            } else {
                while (Character.isDigit(this.current) || this.current == ',' || this.current == ' ' || this.current == ':' || this.current == '-') {
                    switch (this.current) {
                        case ' ': {
                            break;
                        }
                        case ':': {
                            if (buffer.length() == 0) {
                                sliceTo = true;
                                this.current = this.pathFragment.charAt(++this.i);
                                while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                    if (this.current != ' ') {
                                        buffer.append(this.current);
                                    }
                                    this.current = this.pathFragment.charAt(++this.i);
                                }
                                numbers.add(Integer.parseInt(buffer.toString()));
                                buffer.setLength(0);
                                break;
                            }
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            this.current = this.pathFragment.charAt(++this.i);
                            while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                if (this.current != ' ') {
                                    buffer.append(this.current);
                                }
                                this.current = this.pathFragment.charAt(++this.i);
                            }
                            if (buffer.length() == 0) {
                                sliceFrom = true;
                                break;
                            }
                            sliceBetween = true;
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            break;
                        }
                        case ',': {
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            indexSequence = true;
                            break;
                        }
                        default: {
                            buffer.append(this.current);
                        }
                    }
                    if (this.current != ']') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    break;
                }
            }
            if (buffer.length() > 0) {
                numbers.add(Integer.parseInt(buffer.toString()));
            }
            boolean bl = singleIndex = numbers.size() == 1 && !sliceTo && !sliceFrom && !contextSize;
            if (logger.isTraceEnabled()) {
                logger.debug("numbers are                : {}", (Object)((Object)numbers).toString());
                logger.debug("sequence is singleNumber   : {}", (Object)singleIndex);
                logger.debug("sequence is numberSequence : {}", (Object)indexSequence);
                logger.debug("sequence is sliceFrom      : {}", (Object)sliceFrom);
                logger.debug("sequence is sliceTo        : {}", (Object)sliceTo);
                logger.debug("sequence is sliceBetween   : {}", (Object)sliceBetween);
                logger.debug("sequence is contextFetch   : {}", (Object)contextSize);
                logger.debug("---------------------------------------------");
            }
            ArrayPathToken.Operation operation = null;
            if (singleIndex) {
                operation = ArrayPathToken.Operation.SINGLE_INDEX;
            } else if (indexSequence) {
                operation = ArrayPathToken.Operation.INDEX_SEQUENCE;
            } else if (sliceFrom) {
                operation = ArrayPathToken.Operation.SLICE_FROM;
            } else if (sliceTo) {
                operation = ArrayPathToken.Operation.SLICE_TO;
            } else if (sliceBetween) {
                operation = ArrayPathToken.Operation.SLICE_BETWEEN;
            } else if (contextSize) {
                operation = ArrayPathToken.Operation.CONTEXT_SIZE;
            }
            assert (operation != null);
            return new ArrayPathToken(numbers, operation);
        }
    }
}

