/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.collect.Maps;

public class ResponseDefinitionBuilder {
    protected int status = 200;
    protected String statusMessage;
    protected byte[] binaryBody;
    protected String stringBody;
    protected String base64Body;
    protected String bodyFileName;
    protected List<HttpHeader> headers = Lists.newArrayList();
    protected Integer fixedDelayMilliseconds;
    protected DelayDistribution delayDistribution;
    protected String proxyBaseUrl;
    protected Fault fault;
    protected List<String> responseTransformerNames;
    protected Map<String, Object> transformerParameters = Maps.newHashMap();

    public static ResponseDefinitionBuilder like(ResponseDefinition responseDefinition) {
        ResponseDefinitionBuilder builder = new ResponseDefinitionBuilder();
        builder.status = responseDefinition.getStatus();
        builder.headers = responseDefinition.getHeaders() != null ? Lists.newArrayList(responseDefinition.getHeaders().all()) : Lists.newArrayList();
        builder.binaryBody = responseDefinition.getByteBodyIfBinary();
        builder.stringBody = responseDefinition.getBody();
        builder.base64Body = responseDefinition.getBase64Body();
        builder.bodyFileName = responseDefinition.getBodyFileName();
        builder.fixedDelayMilliseconds = responseDefinition.getFixedDelayMilliseconds();
        builder.proxyBaseUrl = responseDefinition.getProxyBaseUrl();
        builder.fault = responseDefinition.getFault();
        builder.responseTransformerNames = responseDefinition.getTransformers();
        return builder;
    }

    public static ResponseDefinition jsonResponse(Object body) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(200).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder but() {
        return this;
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String value) {
        this.headers.add(new HttpHeader(key, value));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.stringBody = body;
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.binaryBody = body;
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder withRandomDelay(DelayDistribution distribution) {
        this.delayDistribution = distribution;
        return this;
    }

    public ResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withRandomDelay(new LogNormal(medianMilliseconds, sigma));
    }

    public ResponseDefinitionBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withRandomDelay(new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public ResponseDefinitionBuilder withTransformers(String ... responseTransformerNames) {
        this.responseTransformerNames = Arrays.asList(responseTransformerNames);
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameter(String name, Object value) {
        this.transformerParameters.put(name, value);
        return this;
    }

    public ResponseDefinitionBuilder withTransformer(String transformerName, String parameterKey, Object parameterValue) {
        this.withTransformers(transformerName);
        this.withTransformerParameter(parameterKey, parameterValue);
        return this;
    }

    public ProxyResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return new ProxyResponseDefinitionBuilder(this);
    }

    public static ResponseDefinitionBuilder responseDefinition() {
        return new ResponseDefinitionBuilder();
    }

    public static <T> ResponseDefinitionBuilder okForJson(T body) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(Json.write(body)).withHeader("Content-Type", "application/json");
    }

    public ResponseDefinitionBuilder withHeaders(HttpHeaders headers) {
        this.headers = ImmutableList.copyOf(headers.all());
        return this;
    }

    public ResponseDefinitionBuilder withBase64Body(String base64Body) {
        this.base64Body = base64Body;
        return this;
    }

    public ResponseDefinitionBuilder withStatusMessage(String message) {
        this.statusMessage = message;
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        return this.build(null);
    }

    private boolean isBinaryBody() {
        return this.binaryBody != null;
    }

    protected ResponseDefinition build(HttpHeaders additionalProxyRequestHeaders) {
        HttpHeaders httpHeaders = this.headers == null || this.headers.isEmpty() ? null : new HttpHeaders(this.headers);
        Parameters transformerParameters = this.transformerParameters.isEmpty() ? null : Parameters.from(this.transformerParameters);
        return this.isBinaryBody() ? new ResponseDefinition(this.status, this.statusMessage, this.binaryBody, null, this.base64Body, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.proxyBaseUrl, this.fault, this.responseTransformerNames, transformerParameters) : new ResponseDefinition(this.status, this.statusMessage, this.stringBody, null, this.base64Body, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.proxyBaseUrl, this.fault, this.responseTransformerNames, transformerParameters);
    }

    public static class ProxyResponseDefinitionBuilder
    extends ResponseDefinitionBuilder {
        private List<HttpHeader> additionalRequestHeaders = Lists.newArrayList();

        public ProxyResponseDefinitionBuilder(ResponseDefinitionBuilder from) {
            this.status = from.status;
            this.headers = from.headers;
            this.binaryBody = from.binaryBody;
            this.stringBody = from.stringBody;
            this.base64Body = from.base64Body;
            this.bodyFileName = from.bodyFileName;
            this.fault = from.fault;
            this.fixedDelayMilliseconds = from.fixedDelayMilliseconds;
            this.proxyBaseUrl = from.proxyBaseUrl;
            this.responseTransformerNames = from.responseTransformerNames;
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeader(String key, String value) {
            this.additionalRequestHeaders.add(new HttpHeader(key, value));
            return this;
        }

        @Override
        public ResponseDefinition build() {
            return !this.additionalRequestHeaders.isEmpty() ? super.build(new HttpHeaders(this.additionalRequestHeaders)) : super.build();
        }
    }
}

