/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.AbstractTransformer;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ResponseDefinition {
    private final int status;
    private final Body body;
    private final String bodyFileName;
    private final HttpHeaders headers;
    private final HttpHeaders additionalProxyRequestHeaders;
    private final Integer fixedDelayMilliseconds;
    private final String proxyBaseUrl;
    private final Fault fault;
    private final List<String> transformers;
    private final Parameters transformerParameters;
    private String browserProxyUrl;
    private boolean wasConfigured = true;
    private Request originalRequest;

    @JsonCreator
    public ResponseDefinition(@JsonProperty(value="status") int status, @JsonProperty(value="body") String body, @JsonProperty(value="jsonBody") JsonNode jsonBody, @JsonProperty(value="base64Body") String base64Body, @JsonProperty(value="bodyFileName") String bodyFileName, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="additionalProxyRequestHeaders") HttpHeaders additionalProxyRequestHeaders, @JsonProperty(value="fixedDelayMilliseconds") Integer fixedDelayMilliseconds, @JsonProperty(value="proxyBaseUrl") String proxyBaseUrl, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="extensionParameters") Parameters transformerParameters) {
        this(status, Body.fromOneOf(null, body, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, fixedDelayMilliseconds, proxyBaseUrl, fault, transformers, transformerParameters);
    }

    public ResponseDefinition(int status, byte[] body, JsonNode jsonBody, String base64Body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, Integer fixedDelayMilliseconds, String proxyBaseUrl, Fault fault, List<String> transformers, Parameters transformerParameters) {
        this(status, Body.fromOneOf(body, null, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, fixedDelayMilliseconds, proxyBaseUrl, fault, transformers, transformerParameters);
    }

    private ResponseDefinition(int status, Body body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, Integer fixedDelayMilliseconds, String proxyBaseUrl, Fault fault, List<String> transformers, Parameters transformerParameters) {
        this.status = status > 0 ? status : 200;
        this.body = body;
        this.bodyFileName = bodyFileName;
        this.headers = headers;
        this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
        this.proxyBaseUrl = proxyBaseUrl;
        this.fault = fault;
        this.transformers = transformers;
        this.transformerParameters = transformerParameters;
    }

    public ResponseDefinition(int statusCode, String bodyContent) {
        this(statusCode, Body.fromString(bodyContent), null, null, null, null, null, null, Collections.emptyList(), Parameters.empty());
    }

    public ResponseDefinition(int statusCode, byte[] bodyContent) {
        this(statusCode, Body.fromBytes(bodyContent), null, null, null, null, null, null, Collections.emptyList(), Parameters.empty());
    }

    public ResponseDefinition() {
        this(200, Body.none(), null, null, null, null, null, null, Collections.emptyList(), Parameters.empty());
    }

    public static ResponseDefinition notFound() {
        return new ResponseDefinition(404, (byte[])null);
    }

    public static ResponseDefinition ok() {
        return new ResponseDefinition(200, (byte[])null);
    }

    public static ResponseDefinition created() {
        return new ResponseDefinition(201, (byte[])null);
    }

    public static ResponseDefinition redirectTo(String path) {
        return new ResponseDefinitionBuilder().withHeader("Location", path).withStatus(302).build();
    }

    public static ResponseDefinition notConfigured() {
        ResponseDefinition response = new ResponseDefinition(404, (byte[])null);
        response.wasConfigured = false;
        return response;
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        ResponseDefinition response = new ResponseDefinition();
        response.browserProxyUrl = originalRequest.getAbsoluteUrl();
        return response;
    }

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        ResponseDefinition newResponseDef = new ResponseDefinition(original.status, original.body, original.bodyFileName, original.headers, original.additionalProxyRequestHeaders, original.fixedDelayMilliseconds, original.proxyBaseUrl, original.fault, original.transformers, original.transformerParameters);
        newResponseDef.wasConfigured = original.wasConfigured;
        return newResponseDef;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpHeaders getAdditionalProxyRequestHeaders() {
        return this.additionalProxyRequestHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return !this.body.isBinary() ? this.body.asString() : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body.asBytes();
    }

    @JsonIgnore
    public byte[] getByteBodyIfBinary() {
        return this.body.isBinary() ? this.body.asBytes() : null;
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured;
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    @JsonIgnore
    public String getProxyUrl() {
        if (this.browserProxyUrl != null) {
            return this.browserProxyUrl;
        }
        return this.proxyBaseUrl + this.originalRequest.getUrl();
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null && this.body.isAbsent();
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body.isPresent();
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body.isPresent() && this.body.isBinary();
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(Request originalRequest) {
        this.originalRequest = originalRequest;
    }

    public Fault getFault() {
        return this.fault;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    public boolean hasTransformer(AbstractTransformer transformer) {
        return this.transformers != null && this.transformers.contains(transformer.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinition that = (ResponseDefinition)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.wasConfigured, that.wasConfigured) && Objects.equals(this.body, that.body) && Objects.equals(this.bodyFileName, that.bodyFileName) && Objects.equals(this.headers, that.headers) && Objects.equals(this.additionalProxyRequestHeaders, that.additionalProxyRequestHeaders) && Objects.equals(this.fixedDelayMilliseconds, that.fixedDelayMilliseconds) && Objects.equals(this.proxyBaseUrl, that.proxyBaseUrl) && Objects.equals(this.browserProxyUrl, that.browserProxyUrl) && Objects.equals((Object)this.fault, (Object)that.fault) && Objects.equals(this.originalRequest, that.originalRequest) && Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformerParameters, that.transformerParameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.proxyBaseUrl, this.browserProxyUrl, this.fault, this.wasConfigured, this.originalRequest, this.transformers});
    }

    public String toString() {
        return Json.write(this);
    }
}

