/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import wiremock.org.eclipse.jetty.client.AbstractConnectionPool;
import wiremock.org.eclipse.jetty.client.ConnectionPool;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.api.Connection;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Pool;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool
implements ConnectionPool.Multiplexable {
    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, Callback requester, int maxMultiplex) {
        this(destination, maxConnections, false, requester, maxMultiplex);
    }

    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, boolean cache, Callback requester, int maxMultiplex) {
        this(destination, new Pool<Connection>(Pool.StrategyType.FIRST, maxConnections, cache), requester, maxMultiplex);
    }

    public MultiplexConnectionPool(HttpDestination destination, Pool<Connection> pool, Callback requester, int maxMultiplex) {
        super(destination, pool, requester);
        this.setMaxMultiplex(maxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The multiplexing factor of connections")
    public int getMaxMultiplex() {
        return super.getMaxMultiplex();
    }

    @Override
    public void setMaxMultiplex(int maxMultiplex) {
        super.setMaxMultiplex(maxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The maximum amount of times a connection is used before it gets closed")
    public int getMaxUsageCount() {
        return super.getMaxUsageCount();
    }

    @Override
    public void setMaxUsageCount(int maxUsageCount) {
        super.setMaxUsageCount(maxUsageCount);
    }
}

