/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import wiremock.com.google.gson.Gson;
import wiremock.com.google.gson.JsonArray;
import wiremock.com.google.gson.JsonElement;
import wiremock.com.google.gson.JsonIOException;
import wiremock.com.google.gson.JsonNull;
import wiremock.com.google.gson.JsonObject;
import wiremock.com.google.gson.JsonParser;
import wiremock.com.google.gson.JsonPrimitive;
import wiremock.com.google.gson.JsonSyntaxException;
import wiremock.net.javacrumbs.jsonunit.core.internal.AbstractNode;
import wiremock.net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.Utils;

class GsonNodeFactory
extends AbstractNodeFactory {
    private final Gson gson = new Gson();

    GsonNodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonElement) {
            return GsonNodeFactory.newNode((JsonElement)source);
        }
        return GsonNodeFactory.newNode(this.gson.toJsonTree(source));
    }

    @Override
    protected Node nullNode() {
        return GsonNodeFactory.newNode((JsonElement)JsonNull.INSTANCE);
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = GsonNodeFactory.newNode(new JsonParser().parse(value));
            return node;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private static Node newNode(JsonElement jsonNode) {
        if (jsonNode != null) {
            return new GsonNode(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JsonElement;
    }

    static final class GsonNode
    extends AbstractNode {
        private final JsonElement jsonNode;

        GsonNode(JsonElement jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            if (this.jsonNode instanceof JsonArray) {
                try {
                    return GsonNodeFactory.newNode(((JsonArray)this.jsonNode).get(index));
                }
                catch (IndexOutOfBoundsException e) {
                    return MISSING_NODE;
                }
            }
            throw new IllegalStateException("Can call element() only on an JsonArray");
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            if (this.jsonNode instanceof JsonObject) {
                final Iterator iterator = ((JsonObject)this.jsonNode).entrySet().iterator();
                return new Iterator<Node.KeyValue>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node.KeyValue next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new Node.KeyValue((String)entry.getKey(), GsonNodeFactory.newNode((JsonElement)entry.getValue()));
                    }
                };
            }
            throw new IllegalStateException("Can call fields() only on an JsonObject");
        }

        @Override
        public Node get(String key) {
            if (this.jsonNode instanceof JsonObject) {
                return GsonNodeFactory.newNode(((JsonObject)this.jsonNode).get(key));
            }
            return Node.MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isJsonNull();
        }

        @Override
        public Iterator<Node> arrayElements() {
            if (this.jsonNode instanceof JsonArray) {
                final Iterator iterator = ((JsonArray)this.jsonNode).iterator();
                return new Iterator<Node>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node next() {
                        JsonElement entry = (JsonElement)iterator.next();
                        return GsonNodeFactory.newNode(entry);
                    }
                };
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public int size() {
            if (this.jsonNode instanceof JsonArray) {
                return ((JsonArray)this.jsonNode).size();
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public String asText() {
            return this.jsonNode.getAsString();
        }

        @Override
        public Node.NodeType getNodeType() {
            if (this.jsonNode.isJsonObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isJsonArray()) {
                return Node.NodeType.ARRAY;
            }
            if (this.jsonNode instanceof JsonPrimitive && ((JsonPrimitive)this.jsonNode).isString()) {
                return Node.NodeType.STRING;
            }
            if (this.jsonNode instanceof JsonPrimitive && ((JsonPrimitive)this.jsonNode).isNumber()) {
                return Node.NodeType.NUMBER;
            }
            if (this.jsonNode instanceof JsonPrimitive && ((JsonPrimitive)this.jsonNode).isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isJsonNull()) {
                return Node.NodeType.NULL;
            }
            throw new IllegalStateException("Unexpected node type " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.getAsBigDecimal();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.getAsBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

