/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty94;

import java.io.IOException;
import wiremock.javax.servlet.http.HttpServletRequest;
import wiremock.javax.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpChannel;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.SslConnectionFactory;
import wiremock.org.eclipse.jetty.server.handler.AbstractHandler;

class ManInTheMiddleSslConnectHandler
extends AbstractHandler {
    private final SslConnectionFactory sslConnectionFactory;

    ManInTheMiddleSslConnectHandler(SslConnectionFactory sslConnectionFactory) {
        this.sslConnectionFactory = sslConnectionFactory;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.sslConnectionFactory.start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.sslConnectionFactory.stop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            baseRequest.setHandled(true);
            this.handleConnect(baseRequest, response);
        }
    }

    private void handleConnect(Request baseRequest, HttpServletResponse response) throws IOException {
        this.sendConnectResponse(response);
        HttpChannel httpChannel = baseRequest.getHttpChannel();
        Connector connector = httpChannel.getConnector();
        EndPoint endpoint = httpChannel.getEndPoint();
        endpoint.setConnection(null);
        Connection connection = this.sslConnectionFactory.newConnection(connector, endpoint);
        endpoint.setConnection(connection);
        endpoint.onOpen();
        connection.onOpen();
    }

    private void sendConnectResponse(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getOutputStream().close();
    }
}

