/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty94;

import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.DefaultMultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty94.SslContexts;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import wiremock.org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import wiremock.org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.SecureRequestCustomizer;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.SslConnectionFactory;
import wiremock.org.eclipse.jetty.server.handler.HandlerCollection;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class Jetty94HttpServer
extends JettyHttpServer {
    public Jetty94HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        super(options, adminRequestHandler, stubRequestHandler);
    }

    @Override
    protected MultipartRequestConfigurer buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigurer();
    }

    @Override
    protected HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = super.createHttpConfig(jettySettings);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setSendServerVersion(false);
        httpConfig.addCustomizer(new SecureRequestCustomizer());
        return httpConfig;
    }

    @Override
    protected ServerConnector createHttpsConnector(Server server, String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        SslContextFactory.Server http2SslContextFactory = SslContexts.buildHttp2SslContextFactory(httpsSettings);
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, alpn.getProtocol());
        ConnectionFactory[] connectionFactories = new ConnectionFactory[]{ssl, alpn, h2, http};
        return this.createServerConnector(bindAddress, jettySettings, httpsSettings.port(), listener, connectionFactories);
    }

    @Override
    protected HandlerCollection createHandler(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        HandlerCollection handler = super.createHandler(options, adminRequestHandler, stubRequestHandler);
        if (options.browserProxySettings().enabled()) {
            handler.addHandler(SslContexts.buildManInTheMiddleSslConnectHandler(options));
        }
        return handler;
    }
}

