/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import wiremock.org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import wiremock.org.eclipse.jetty.client.DuplexConnectionPool;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.Origin;
import wiremock.org.eclipse.jetty.client.api.Destination;
import wiremock.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.ProcessorUtils;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool((Destination)destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<wiremock.org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

