/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.util.resource.ResourceCollection;

public class WebAppClassLoader
extends URLClassLoader {
    private static final Logger LOG;
    private static final ThreadLocal<Boolean> __loadServerClasses;
    private final Context _context;
    private final ClassLoader _parent;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();

    public static <T> T runWithServerClassAccess(PrivilegedExceptionAction<T> action) throws Exception {
        Boolean lsc = __loadServerClasses.get();
        try {
            __loadServerClasses.set(true);
            T t = action.run();
            return t;
        }
        finally {
            if (lsc == null) {
                __loadServerClasses.remove();
            } else {
                __loadServerClasses.set(lsc);
            }
        }
    }

    public WebAppClassLoader(Context context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, Context context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._parent = this.getParent();
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) throws IOException {
        if (resource instanceof ResourceCollection) {
            for (Resource r : ((ResourceCollection)resource).getResources()) {
                this.addClassPath(r);
            }
        } else {
            this.addClassPath(resource.toString());
        }
    }

    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = this._context.newResource(tokenizer.nextToken().trim());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path resource=" + resource, new Object[0]);
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection) {
                this.addClassPath(resource);
                continue;
            }
            File file = resource.getFile();
            if (file != null) {
                URL url = resource.getURI().toURL();
                this.addURL(url);
                continue;
            }
            if (resource.isDirectory()) {
                this.addURL(resource.getURI().toURL());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check file exists and is not nested jar: " + resource, new Object[0]);
            }
            throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + resource);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            Object[] files = lib.list();
            if (files != null) {
                Arrays.sort(files);
            }
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String fnlc;
                    Resource fn = lib.addPath((String)files[f]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("addJar - {}", fn);
                    }
                    if (!this.isFileSupported(fnlc = fn.getName().toLowerCase(Locale.ENGLISH))) continue;
                    String jar = fn.toString();
                    jar = StringUtil.replace(jar, ",", "%2C");
                    jar = StringUtil.replace(jar, ";", "%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", ex);
                }
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> resources;
        URL url;
        ArrayList<URL> from_parent = new ArrayList<URL>();
        ArrayList<URL> from_webapp = new ArrayList<URL>();
        Enumeration<URL> urls = this._parent.getResources(name);
        while (urls != null && urls.hasMoreElements()) {
            url = urls.nextElement();
            if (!Boolean.TRUE.equals(__loadServerClasses.get()) && this._context.isServerResource(name, url)) continue;
            from_parent.add(url);
        }
        urls = this.findResources(name);
        while (urls != null && urls.hasMoreElements()) {
            url = urls.nextElement();
            if (this._context.isSystemResource(name, url) && !from_parent.isEmpty()) continue;
            from_webapp.add(url);
        }
        if (this._context.isParentLoaderPriority()) {
            from_parent.addAll(from_webapp);
            resources = from_parent;
        } else {
            from_webapp.addAll(from_parent);
            resources = from_webapp;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResources {} {}", name, resources);
        }
        return Collections.enumeration(resources);
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        if (this._context.isParentLoaderPriority()) {
            URL parent_url = this._parent.getResource(name);
            if (parent_url != null && (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerResource(name, parent_url))) {
                resource = parent_url;
            } else {
                URL webapp_url = this.findResource(name);
                if (webapp_url != null) {
                    resource = webapp_url;
                }
            }
        } else {
            URL webapp_url = this.findResource(name);
            if (webapp_url != null && !this._context.isSystemResource(name, webapp_url)) {
                resource = webapp_url;
            } else {
                URL parent_url = this._parent.getResource(name);
                if (parent_url != null && (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerResource(name, parent_url))) {
                    resource = parent_url;
                } else if (webapp_url != null) {
                    resource = webapp_url;
                }
            }
        }
        if (resource == null && name.startsWith("/")) {
            resource = this.getResource(name.substring(1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResource {} {}", name, resource);
        }
        return resource;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassNotFoundException ex = null;
            Class<?> parent_class = null;
            Class<?> webapp_class = null;
            webapp_class = this.findLoadedClass(name);
            if (webapp_class != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found webapp loaded {}", webapp_class);
                }
                return webapp_class;
            }
            if (this._context.isParentLoaderPriority()) {
                try {
                    parent_class = this._parent.loadClass(name);
                    if (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerClass(parent_class)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("PLP parent loaded {}", parent_class);
                        }
                        return parent_class;
                    }
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
                try {
                    webapp_class = this.findClass(name);
                    this.resolveClass(webapp_class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PLP webapp loaded {}", webapp_class);
                    }
                    return webapp_class;
                }
                catch (ClassNotFoundException e) {
                    if (ex == null) {
                        ex = e;
                    } else if (e != ex) {
                        ex.addSuppressed(e);
                    }
                    throw ex;
                }
            }
            webapp_class = this.loadAsResource(name, true);
            if (webapp_class != null) {
                return webapp_class;
            }
            try {
                parent_class = this._parent.loadClass(name);
                if (Boolean.TRUE.equals(__loadServerClasses.get()) || !this._context.isServerClass(parent_class)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WAP parent loaded {}", parent_class);
                    }
                    return parent_class;
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            webapp_class = this.loadAsResource(name, false);
            if (webapp_class != null) {
                return webapp_class;
            }
            throw ex == null ? new ClassNotFoundException(name) : ex;
        }
    }

    @Deprecated
    public void addClassFileTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    @Deprecated
    public boolean removeClassFileTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    protected Class<?> loadAsResource(String name, boolean checkSystemResource) throws ClassNotFoundException {
        Class<?> webapp_class = null;
        String path = name.replace('.', '/').concat(".class");
        URL webapp_url = this.findResource(path);
        if (!(webapp_url == null || checkSystemResource && this._context.isSystemResource(name, webapp_url))) {
            webapp_class = this.foundClass(name, webapp_url);
            this.resolveClass(webapp_class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WAP webapp loaded {}", webapp_class);
            }
        }
        return webapp_class;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name);
        }
        String path = name.replace('.', '/').concat(".class");
        URL url = this.findResource(path);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        return this.foundClass(name, url);
    }

    protected Class<?> foundClass(String name, URL url) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name);
        }
        InputStream content = null;
        try {
            content = url.openStream();
            byte[] bytes = IO.readBytes(content);
            if (LOG.isDebugEnabled()) {
                LOG.debug("foundClass({}) url={} cl={}", name, url, this);
            }
            for (ClassFileTransformer transformer : this._transformers) {
                byte[] tmp = transformer.transform(this, name, null, null, bytes);
                if (tmp == null) continue;
                bytes = tmp;
            }
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        catch (IllegalClassFormatException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "WebAppClassLoader=" + this._name + "@" + Long.toHexString(this.hashCode());
    }

    static {
        WebAppClassLoader.registerAsParallelCapable();
        LOG = Log.getLogger(WebAppClassLoader.class);
        __loadServerClasses = new ThreadLocal();
    }

    public static interface Context {
        public Resource newResource(String var1) throws IOException;

        public PermissionCollection getPermissions();

        public boolean isSystemClass(Class<?> var1);

        public boolean isServerClass(Class<?> var1);

        public boolean isParentLoaderPriority();

        public String getExtraClasspath();

        public boolean isServerResource(String var1, URL var2);

        public boolean isSystemResource(String var1, URL var2);
    }
}

