/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.net.Socket;
import java.net.URI;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.server.HttpChannel;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;

public class JettyUtils {
    public static Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        return (Response)httpServletResponse;
    }

    public static Socket getTlsSocket(Response response) {
        HttpChannel httpChannel = response.getHttpOutput().getHttpChannel();
        SslConnection.DecryptedEndPoint sslEndpoint = (SslConnection.DecryptedEndPoint)httpChannel.getEndPoint();
        EndPoint endpoint = sslEndpoint.getSslConnection().getEndPoint();
        try {
            return (Socket)endpoint.getClass().getMethod("getSocket", new Class[0]).invoke((Object)endpoint, new Object[0]);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Socket.class);
        }
    }

    public static URI getUri(Request request) {
        try {
            return JettyUtils.toUri(request.getClass().getDeclaredMethod("getUri", new Class[0]).invoke((Object)request, new Object[0]));
        }
        catch (Exception ignored) {
            try {
                return JettyUtils.toUri(request.getClass().getDeclaredMethod("getHttpURI", new Class[0]).invoke((Object)request, new Object[0]));
            }
            catch (Exception ignored2) {
                throw new IllegalArgumentException(request + " does not have a getUri or getHttpURI method");
            }
        }
    }

    private static URI toUri(Object httpURI) {
        return URI.create(httpURI.toString());
    }
}

