/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassPath;
import com.github.tmurakami.dexopener.Loggers;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Installer {
    private final ClassPath classPath;

    Installer(ClassPath classPath) {
        this.classPath = classPath;
    }

    void installTo(ClassLoader target) {
        Field parentField;
        for (ClassLoader l = target; l != null; l = l.getParent()) {
            if (!(l instanceof Injector)) continue;
            throw new IllegalStateException("Already installed");
        }
        try {
            parentField = ClassLoader.class.getDeclaredField("parent");
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedOperationException(e);
        }
        Injector injector = new Injector(target, this.classPath);
        do {
            parentField.setAccessible(true);
            try {
                parentField.set(target, injector);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        } while (target.getParent() != injector);
    }

    private static final class Injector
    extends ClassLoader {
        private final ClassLoader target;
        private final ClassPath classPath;

        private Injector(ClassLoader target, ClassPath classPath) {
            super(target.getParent());
            this.target = target;
            this.classPath = classPath;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class c = this.classPath.loadClass(name, this.target);
            if (c == null) {
                return super.findClass(name);
            }
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                String hash = Integer.toHexString(System.identityHashCode(this.target));
                String target = this.target.getClass().getName() + '@' + hash;
                logger.finest("The class " + c.getName() + " was injected into " + target);
            }
            return c;
        }
    }
}

