/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import androidx.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassPath;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.Installer;
import com.github.tmurakami.dexopener.Loggers;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DexOpener {
    private static final String[] REFUSED_PACKAGES = new String[]{"com.github.tmurakami.dexopener.", "android.", "androidx.", "com.android.", "com.google.android.", "com.sun.", "dalvik.", "java.", "javax.", "libcore.", "org.apache.commons.logging.", "org.apache.harmony.", "org.apache.http.", "org.ccil.cowan.tagsoup.", "org.json.", "org.kxml2.io.", "org.w3c.dom.", "org.xml.sax.", "org.xmlpull.v1.", "sun.", "junit.", "org.hamcrest.", "org.junit."};
    private static final Executor EXECUTOR;

    private DexOpener() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalStateException("The Instrumentation instance has not yet been initialized");
        }
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("An Application instance has already been created");
        }
        ClassNameFilter classNameFilter = DexOpener.createClassNameFilter(instrumentation.getClass());
        ClassPath path = new ClassPath(context, classNameFilter, new DexFileLoader(), EXECUTOR);
        new Installer(path).installTo(context.getClassLoader());
    }

    private static ClassNameFilter createClassNameFilter(Class<?> rootClass) {
        String packageName;
        String className = rootClass.getName();
        int lastDotPos = className.lastIndexOf(46);
        String string = packageName = lastDotPos == -1 ? null : className.substring(0, lastDotPos);
        if (DexOpener.isSupportedPackage(packageName)) {
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("The package to be opened: " + packageName + ".**");
            }
            return new ClassNameFilter(packageName, rootClass);
        }
        throw new UnsupportedOperationException("Manipulating final classes belonging to the '" + packageName + "' package is not supported");
    }

    private static boolean isSupportedPackage(String packageName) {
        if (packageName == null || packageName.indexOf(46) == -1) {
            return false;
        }
        for (String pkg : REFUSED_PACKAGES) {
            if (!packageName.startsWith(pkg)) continue;
            return false;
        }
        return true;
    }

    static {
        final AtomicInteger count = new AtomicInteger();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = Math.max(1, Math.min(availableProcessors, 4));
        EXECUTOR = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "DexOpener #" + count.incrementAndGet());
            }
        });
    }
}

