/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.com.google.common.primitives.Ints;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.AccessFlags;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.MutableMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.HeaderItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.TryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.LineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.VariableRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction4rcc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.CallSiteReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodHandleReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.StringReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.InstructionUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.MethodUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.AnnotationSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.AnnotationSetSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.CallSiteSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.ClassSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DebugWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexDataWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.EncodedArraySection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.EncodedValueWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.FieldSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.IndexSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.InstructionWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.MethodHandleSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.MethodSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.ProtoSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.StringSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeListSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DeferredOutputStream;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DeferredOutputStreamFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.MemoryDeferredOutputStream;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.util.TryListBuilder;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;

public abstract class DexWriter<StringKey extends CharSequence, StringRef extends StringReference, TypeKey extends CharSequence, TypeRef extends TypeReference, ProtoRefKey extends MethodProtoReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ClassKey extends Comparable<? super ClassKey>, CallSiteKey extends CallSiteReference, MethodHandleKey extends MethodHandleReference, AnnotationKey extends Annotation, AnnotationSetKey, TypeListKey, FieldKey, MethodKey, EncodedArrayKey, EncodedValue, AnnotationElement extends AnnotationElement, StringSectionType extends StringSection<StringKey, StringRef>, TypeSectionType extends TypeSection<StringKey, TypeKey, TypeRef>, ProtoSectionType extends ProtoSection<StringKey, TypeKey, ProtoRefKey, TypeListKey>, FieldSectionType extends FieldSection<StringKey, TypeKey, FieldRefKey, FieldKey>, MethodSectionType extends MethodSection<StringKey, TypeKey, ProtoRefKey, MethodRefKey, MethodKey>, ClassSectionType extends ClassSection<StringKey, TypeKey, TypeListKey, ClassKey, FieldKey, MethodKey, AnnotationSetKey, EncodedArrayKey>, CallSiteSectionType extends CallSiteSection<CallSiteKey, EncodedArrayKey>, MethodHandleSectionType extends MethodHandleSection<MethodHandleKey, FieldRefKey, MethodRefKey>, TypeListSectionType extends TypeListSection<TypeKey, TypeListKey>, AnnotationSectionType extends AnnotationSection<StringKey, TypeKey, AnnotationKey, AnnotationElement, EncodedValue>, AnnotationSetSectionType extends AnnotationSetSection<AnnotationKey, AnnotationSetKey>, EncodedArraySectionType extends EncodedArraySection<EncodedArrayKey, EncodedValue>> {
    protected final Opcodes opcodes;
    protected int stringIndexSectionOffset = 0;
    protected int typeSectionOffset = 0;
    protected int protoSectionOffset = 0;
    protected int fieldSectionOffset = 0;
    protected int methodSectionOffset = 0;
    protected int classIndexSectionOffset = 0;
    protected int callSiteSectionOffset = 0;
    protected int methodHandleSectionOffset = 0;
    protected int stringDataSectionOffset = 0;
    protected int classDataSectionOffset = 0;
    protected int typeListSectionOffset = 0;
    protected int encodedArraySectionOffset = 0;
    protected int annotationSectionOffset = 0;
    protected int annotationSetSectionOffset = 0;
    protected int annotationSetRefSectionOffset = 0;
    protected int annotationDirectorySectionOffset = 0;
    protected int debugSectionOffset = 0;
    protected int codeSectionOffset = 0;
    protected int mapSectionOffset = 0;
    protected int numAnnotationSetRefItems = 0;
    protected int numAnnotationDirectoryItems = 0;
    protected int numDebugInfoItems = 0;
    protected int numCodeItemItems = 0;
    protected int numClassDataItems = 0;
    public final StringSectionType stringSection;
    public final TypeSectionType typeSection;
    public final ProtoSectionType protoSection;
    public final FieldSectionType fieldSection;
    public final MethodSectionType methodSection;
    public final ClassSectionType classSection;
    public final CallSiteSectionType callSiteSection;
    public final MethodHandleSectionType methodHandleSection;
    public final TypeListSectionType typeListSection;
    public final AnnotationSectionType annotationSection;
    public final AnnotationSetSectionType annotationSetSection;
    public final EncodedArraySectionType encodedArraySection;
    private final IndexSection<?>[] overflowableSections;
    private Comparator<Map.Entry<? extends CallSiteKey, Integer>> callSiteComparator = new Comparator<Map.Entry<? extends CallSiteKey, Integer>>(){

        @Override
        public int compare(Map.Entry<? extends CallSiteKey, Integer> entry, Map.Entry<? extends CallSiteKey, Integer> entry2) {
            int n = DexWriter.this.encodedArraySection.getItemOffset(DexWriter.this.callSiteSection.getEncodedCallSite((CallSiteReference)((CallSiteReference)entry.getKey())));
            int n2 = DexWriter.this.encodedArraySection.getItemOffset(DexWriter.this.callSiteSection.getEncodedCallSite((CallSiteReference)((CallSiteReference)entry2.getKey())));
            return Ints.compare(n, n2);
        }
    };
    private static Comparator<Map.Entry> toStringKeyComparator = new Comparator<Map.Entry>(){

        @Override
        public int compare(Map.Entry entry, Map.Entry entry2) {
            return entry.getKey().toString().compareTo(entry2.getKey().toString());
        }
    };

    protected DexWriter(Opcodes opcodes) {
        this.opcodes = opcodes;
        SectionProvider sectionProvider = this.getSectionProvider();
        this.stringSection = sectionProvider.getStringSection();
        this.typeSection = sectionProvider.getTypeSection();
        this.protoSection = sectionProvider.getProtoSection();
        this.fieldSection = sectionProvider.getFieldSection();
        this.methodSection = sectionProvider.getMethodSection();
        this.classSection = sectionProvider.getClassSection();
        this.callSiteSection = sectionProvider.getCallSiteSection();
        this.methodHandleSection = sectionProvider.getMethodHandleSection();
        this.typeListSection = sectionProvider.getTypeListSection();
        this.annotationSection = sectionProvider.getAnnotationSection();
        this.annotationSetSection = sectionProvider.getAnnotationSetSection();
        this.encodedArraySection = sectionProvider.getEncodedArraySection();
        this.overflowableSections = new IndexSection[]{this.typeSection, this.protoSection, this.fieldSection, this.methodSection, this.callSiteSection, this.methodHandleSection};
    }

    protected abstract SectionProvider getSectionProvider();

    protected abstract void writeEncodedValue(InternalEncodedValueWriter var1, EncodedValue var2) throws IOException;

    private static <T extends Comparable<? super T>> Comparator<Map.Entry<? extends T, ?>> comparableKeyComparator() {
        return new Comparator<Map.Entry<? extends T, ?>>(){

            @Override
            public int compare(Map.Entry<? extends T, ?> entry, Map.Entry<? extends T, ?> entry2) {
                return ((Comparable)entry.getKey()).compareTo(entry2.getKey());
            }
        };
    }

    private int getDataSectionOffset() {
        return 112 + this.stringSection.getItemCount() * 4 + this.typeSection.getItemCount() * 4 + this.protoSection.getItemCount() * 12 + this.fieldSection.getItemCount() * 8 + this.methodSection.getItemCount() * 8 + this.classSection.getItemCount() * 32 + this.callSiteSection.getItemCount() * 4 + this.methodHandleSection.getItemCount() * 8;
    }

    public void writeTo(DexDataStore dexDataStore) throws IOException {
        this.writeTo(dexDataStore, MemoryDeferredOutputStream.getFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DexDataStore dexDataStore, DeferredOutputStreamFactory deferredOutputStreamFactory) throws IOException {
        try {
            int n = this.getDataSectionOffset();
            DexDataWriter dexDataWriter = DexWriter.outputAt(dexDataStore, 0);
            DexDataWriter dexDataWriter2 = DexWriter.outputAt(dexDataStore, 112);
            DexDataWriter dexDataWriter3 = DexWriter.outputAt(dexDataStore, n);
            try {
                this.writeStrings(dexDataWriter2, dexDataWriter3);
                this.writeTypes(dexDataWriter2);
                this.writeTypeLists(dexDataWriter3);
                this.writeProtos(dexDataWriter2);
                this.writeFields(dexDataWriter2);
                this.writeMethods(dexDataWriter2);
                try (DexDataWriter dexDataWriter4 = DexWriter.outputAt(dexDataStore, dexDataWriter2.getPosition() + this.classSection.getItemCount() * 32 + this.callSiteSection.getItemCount() * 4);){
                    this.writeMethodHandles(dexDataWriter4);
                }
                this.writeEncodedArrays(dexDataWriter3);
                try (DexDataWriter dexDataWriter5 = DexWriter.outputAt(dexDataStore, dexDataWriter2.getPosition() + this.classSection.getItemCount() * 32);){
                    this.writeCallSites(dexDataWriter5);
                }
                this.writeAnnotations(dexDataWriter3);
                this.writeAnnotationSets(dexDataWriter3);
                this.writeAnnotationSetRefs(dexDataWriter3);
                this.writeAnnotationDirectories(dexDataWriter3);
                this.writeDebugAndCodeItems(dexDataWriter3, deferredOutputStreamFactory.makeDeferredOutputStream());
                this.writeClasses(dexDataWriter2, dexDataWriter3);
                this.writeMapItem(dexDataWriter3);
                this.writeHeader(dexDataWriter, n, dexDataWriter3.getPosition());
            }
            finally {
                dexDataWriter.close();
                dexDataWriter2.close();
                dexDataWriter3.close();
            }
            this.updateSignature(dexDataStore);
            this.updateChecksum(dexDataStore);
        }
        finally {
            dexDataStore.close();
        }
    }

    private void updateSignature(DexDataStore dexDataStore) throws IOException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        byte[] byArray = new byte[4096];
        InputStream inputStream = dexDataStore.readAt(32);
        int n = inputStream.read(byArray);
        while (n >= 0) {
            messageDigest.update(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byte[] byArray2 = messageDigest.digest();
        if (byArray2.length != 20) {
            throw new RuntimeException("unexpected digest write: " + byArray2.length + " bytes");
        }
        OutputStream outputStream = dexDataStore.outputAt(12);
        outputStream.write(byArray2);
        outputStream.close();
    }

    private void updateChecksum(DexDataStore dexDataStore) throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byArray = new byte[4096];
        InputStream inputStream = dexDataStore.readAt(12);
        int n = inputStream.read(byArray);
        while (n >= 0) {
            adler32.update(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        OutputStream outputStream = dexDataStore.outputAt(8);
        DexDataWriter.writeInt(outputStream, (int)adler32.getValue());
        outputStream.close();
    }

    private static DexDataWriter outputAt(DexDataStore dexDataStore, int n) throws IOException {
        return new DexDataWriter(dexDataStore.outputAt(n), n);
    }

    private void writeStrings(DexDataWriter dexDataWriter, DexDataWriter dexDataWriter2) throws IOException {
        this.stringIndexSectionOffset = dexDataWriter.getPosition();
        this.stringDataSectionOffset = dexDataWriter2.getPosition();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList(this.stringSection.getItems());
        Collections.sort(arrayList, toStringKeyComparator);
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            dexDataWriter.writeInt(dexDataWriter2.getPosition());
            String string = ((CharSequence)entry.getKey()).toString();
            dexDataWriter2.writeUleb128(string.length());
            dexDataWriter2.writeString(string);
            dexDataWriter2.write(0);
        }
    }

    private void writeTypes(DexDataWriter dexDataWriter) throws IOException {
        this.typeSectionOffset = dexDataWriter.getPosition();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList(this.typeSection.getItems());
        Collections.sort(arrayList, toStringKeyComparator);
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            dexDataWriter.writeInt(this.stringSection.getItemIndex(this.typeSection.getString(entry.getKey())));
        }
    }

    private void writeProtos(DexDataWriter dexDataWriter) throws IOException {
        this.protoSectionOffset = dexDataWriter.getPosition();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList(this.protoSection.getItems());
        Collections.sort(arrayList, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            MethodProtoReference methodProtoReference = (MethodProtoReference)entry.getKey();
            dexDataWriter.writeInt(this.stringSection.getItemIndex(this.protoSection.getShorty((MethodProtoReference)methodProtoReference)));
            dexDataWriter.writeInt(this.typeSection.getItemIndex(this.protoSection.getReturnType((MethodProtoReference)methodProtoReference)));
            dexDataWriter.writeInt(this.typeListSection.getNullableItemOffset(this.protoSection.getParameters((MethodProtoReference)methodProtoReference)));
        }
    }

    private void writeFields(DexDataWriter dexDataWriter) throws IOException {
        this.fieldSectionOffset = dexDataWriter.getPosition();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList(this.fieldSection.getItems());
        Collections.sort(arrayList, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            FieldReference fieldReference = (FieldReference)entry.getKey();
            dexDataWriter.writeUshort(this.typeSection.getItemIndex(this.fieldSection.getDefiningClass((FieldReference)fieldReference)));
            dexDataWriter.writeUshort(this.typeSection.getItemIndex(this.fieldSection.getFieldType((FieldReference)fieldReference)));
            dexDataWriter.writeInt(this.stringSection.getItemIndex(this.fieldSection.getName((FieldReference)fieldReference)));
        }
    }

    private void writeMethods(DexDataWriter dexDataWriter) throws IOException {
        this.methodSectionOffset = dexDataWriter.getPosition();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList(this.methodSection.getItems());
        Collections.sort(arrayList, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            MethodReference methodReference = (MethodReference)entry.getKey();
            dexDataWriter.writeUshort(this.typeSection.getItemIndex(this.methodSection.getDefiningClass((MethodReference)methodReference)));
            dexDataWriter.writeUshort(this.protoSection.getItemIndex(this.methodSection.getPrototype((MethodReference)methodReference)));
            dexDataWriter.writeInt(this.stringSection.getItemIndex(this.methodSection.getName((MethodReference)methodReference)));
        }
    }

    private void writeClasses(DexDataWriter dexDataWriter, DexDataWriter dexDataWriter2) throws IOException {
        this.classIndexSectionOffset = dexDataWriter.getPosition();
        this.classDataSectionOffset = dexDataWriter2.getPosition();
        ArrayList arrayList = Lists.newArrayList(this.classSection.getItems());
        Collections.sort(arrayList, DexWriter.comparableKeyComparator());
        int n = 0;
        for (Map.Entry entry : arrayList) {
            n = this.writeClass(dexDataWriter, dexDataWriter2, n, entry);
        }
    }

    private int writeClass(DexDataWriter dexDataWriter, DexDataWriter dexDataWriter2, int n, Map.Entry<? extends ClassKey, Integer> entry) throws IOException {
        boolean bl;
        Object object;
        Object object22;
        if (entry == null) {
            return n;
        }
        if (entry.getValue() != -1) {
            return n;
        }
        Comparable comparable = (Comparable)entry.getKey();
        entry.setValue(0);
        Map.Entry entry2 = this.classSection.getClassEntryByType(this.classSection.getSuperclass((Comparable)comparable));
        n = this.writeClass(dexDataWriter, dexDataWriter2, n, entry2);
        for (Object object22 : this.typeListSection.getTypes(this.classSection.getInterfaces((Comparable)comparable))) {
            object = this.classSection.getClassEntryByType((CharSequence)object22);
            n = this.writeClass(dexDataWriter, dexDataWriter2, n, (Map.Entry<? extends ClassKey, Integer>)object);
        }
        entry.setValue(n++);
        dexDataWriter.writeInt(this.typeSection.getItemIndex(this.classSection.getType((Comparable)comparable)));
        dexDataWriter.writeInt(this.classSection.getAccessFlags((Comparable)comparable));
        dexDataWriter.writeInt(this.typeSection.getNullableItemIndex(this.classSection.getSuperclass((Comparable)comparable)));
        dexDataWriter.writeInt(this.typeListSection.getNullableItemOffset(this.classSection.getInterfaces((Comparable)comparable)));
        dexDataWriter.writeInt(this.stringSection.getNullableItemIndex(this.classSection.getSourceFile((Comparable)comparable)));
        dexDataWriter.writeInt(this.classSection.getAnnotationDirectoryOffset((Comparable)comparable));
        Collection collection = this.classSection.getSortedStaticFields((Comparable)comparable);
        object22 = this.classSection.getSortedInstanceFields((Comparable)comparable);
        object = this.classSection.getSortedDirectMethods((Comparable)comparable);
        Collection collection2 = this.classSection.getSortedVirtualMethods((Comparable)comparable);
        boolean bl2 = bl = collection.size() > 0 || object22.size() > 0 || object.size() > 0 || collection2.size() > 0;
        if (bl) {
            dexDataWriter.writeInt(dexDataWriter2.getPosition());
        } else {
            dexDataWriter.writeInt(0);
        }
        Object EncodedArrayKey = this.classSection.getStaticInitializers((Comparable)comparable);
        if (EncodedArrayKey != null) {
            dexDataWriter.writeInt(this.encodedArraySection.getItemOffset(EncodedArrayKey));
        } else {
            dexDataWriter.writeInt(0);
        }
        if (bl) {
            ++this.numClassDataItems;
            dexDataWriter2.writeUleb128(collection.size());
            dexDataWriter2.writeUleb128(object22.size());
            dexDataWriter2.writeUleb128(object.size());
            dexDataWriter2.writeUleb128(collection2.size());
            this.writeEncodedFields(dexDataWriter2, collection);
            this.writeEncodedFields(dexDataWriter2, (Collection<? extends FieldKey>)object22);
            this.writeEncodedMethods(dexDataWriter2, (Collection<? extends MethodKey>)object);
            this.writeEncodedMethods(dexDataWriter2, collection2);
        }
        return n;
    }

    private void writeCallSites(DexDataWriter dexDataWriter) throws IOException {
        this.callSiteSectionOffset = dexDataWriter.getPosition();
        ArrayList arrayList = Lists.newArrayList(this.callSiteSection.getItems());
        Collections.sort(arrayList, this.callSiteComparator);
        int n = 0;
        for (Map.Entry entry : arrayList) {
            entry.setValue(n++);
            dexDataWriter.writeInt(this.encodedArraySection.getItemOffset(this.callSiteSection.getEncodedCallSite((CallSiteReference)((CallSiteReference)entry.getKey()))));
        }
    }

    private void writeMethodHandles(DexDataWriter dexDataWriter) throws IOException {
        this.methodHandleSectionOffset = dexDataWriter.getPosition();
        int n = 0;
        for (Map.Entry entry : this.methodHandleSection.getItems()) {
            int n2;
            entry.setValue(n++);
            MethodHandleReference methodHandleReference = (MethodHandleReference)entry.getKey();
            dexDataWriter.writeUshort(methodHandleReference.getMethodHandleType());
            dexDataWriter.writeUshort(0);
            switch (methodHandleReference.getMethodHandleType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    n2 = this.fieldSection.getItemIndex(this.methodHandleSection.getFieldReference((MethodHandleReference)methodHandleReference));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = this.methodSection.getItemIndex(this.methodHandleSection.getMethodReference((MethodHandleReference)methodHandleReference));
                    break;
                }
                default: {
                    throw new ExceptionWithContext("Invalid method handle type: %d", methodHandleReference.getMethodHandleType());
                }
            }
            dexDataWriter.writeUshort(n2);
            dexDataWriter.writeUshort(0);
        }
    }

    private void writeEncodedFields(DexDataWriter dexDataWriter, Collection<? extends FieldKey> collection) throws IOException {
        int n = 0;
        for (FieldKey FieldKey : collection) {
            int n2 = this.fieldSection.getFieldIndex(FieldKey);
            dexDataWriter.writeUleb128(n2 - n);
            dexDataWriter.writeUleb128(this.classSection.getFieldAccessFlags(FieldKey));
            n = n2;
        }
    }

    private void writeEncodedMethods(DexDataWriter dexDataWriter, Collection<? extends MethodKey> collection) throws IOException {
        int n = 0;
        for (MethodKey MethodKey : collection) {
            int n2 = this.methodSection.getMethodIndex(MethodKey);
            dexDataWriter.writeUleb128(n2 - n);
            dexDataWriter.writeUleb128(this.classSection.getMethodAccessFlags(MethodKey));
            dexDataWriter.writeUleb128(this.classSection.getCodeItemOffset(MethodKey));
            n = n2;
        }
    }

    private void writeTypeLists(DexDataWriter dexDataWriter) throws IOException {
        dexDataWriter.align();
        this.typeListSectionOffset = dexDataWriter.getPosition();
        for (Map.Entry entry : this.typeListSection.getItems()) {
            dexDataWriter.align();
            entry.setValue(dexDataWriter.getPosition());
            Collection collection = this.typeListSection.getTypes(entry.getKey());
            dexDataWriter.writeInt(collection.size());
            for (CharSequence charSequence : collection) {
                dexDataWriter.writeUshort(this.typeSection.getItemIndex((CharSequence)charSequence));
            }
        }
    }

    private void writeEncodedArrays(DexDataWriter dexDataWriter) throws IOException {
        InternalEncodedValueWriter internalEncodedValueWriter = new InternalEncodedValueWriter(dexDataWriter);
        this.encodedArraySectionOffset = dexDataWriter.getPosition();
        for (Map.Entry entry : this.encodedArraySection.getItems()) {
            entry.setValue(dexDataWriter.getPosition());
            List list = this.encodedArraySection.getEncodedValueList(entry.getKey());
            dexDataWriter.writeUleb128(list.size());
            for (Object EncodedValue2 : list) {
                this.writeEncodedValue(internalEncodedValueWriter, EncodedValue2);
            }
        }
    }

    private void writeAnnotations(DexDataWriter dexDataWriter) throws IOException {
        InternalEncodedValueWriter internalEncodedValueWriter = new InternalEncodedValueWriter(dexDataWriter);
        this.annotationSectionOffset = dexDataWriter.getPosition();
        for (Map.Entry entry : this.annotationSection.getItems()) {
            entry.setValue(dexDataWriter.getPosition());
            Annotation annotation = (Annotation)entry.getKey();
            dexDataWriter.writeUbyte(this.annotationSection.getVisibility((Annotation)annotation));
            dexDataWriter.writeUleb128(this.typeSection.getItemIndex(this.annotationSection.getType((Annotation)annotation)));
            ImmutableList immutableList = Ordering.from(BaseAnnotationElement.BY_NAME).immutableSortedCopy(this.annotationSection.getElements((Annotation)annotation));
            dexDataWriter.writeUleb128(immutableList.size());
            for (AnnotationElement annotationElement : immutableList) {
                dexDataWriter.writeUleb128(this.stringSection.getItemIndex(this.annotationSection.getElementName((AnnotationElement)annotationElement)));
                this.writeEncodedValue(internalEncodedValueWriter, this.annotationSection.getElementValue((AnnotationElement)annotationElement));
            }
        }
    }

    private void writeAnnotationSets(DexDataWriter dexDataWriter) throws IOException {
        dexDataWriter.align();
        this.annotationSetSectionOffset = dexDataWriter.getPosition();
        if (this.shouldCreateEmptyAnnotationSet()) {
            dexDataWriter.writeInt(0);
        }
        for (Map.Entry entry : this.annotationSetSection.getItems()) {
            ImmutableList immutableList = Ordering.from(BaseAnnotation.BY_TYPE).immutableSortedCopy(this.annotationSetSection.getAnnotations(entry.getKey()));
            dexDataWriter.align();
            entry.setValue(dexDataWriter.getPosition());
            dexDataWriter.writeInt(immutableList.size());
            for (Annotation annotation : immutableList) {
                dexDataWriter.writeInt(this.annotationSection.getItemOffset((Annotation)annotation));
            }
        }
    }

    private void writeAnnotationSetRefs(DexDataWriter dexDataWriter) throws IOException {
        dexDataWriter.align();
        this.annotationSetRefSectionOffset = dexDataWriter.getPosition();
        HashMap hashMap = Maps.newHashMap();
        for (Comparable comparable : this.classSection.getSortedClasses()) {
            for (Object MethodKey : this.classSection.getSortedMethods((Comparable)comparable)) {
                List list = this.classSection.getParameterAnnotations(MethodKey);
                if (list == null) continue;
                Integer n = (Integer)hashMap.get(list);
                if (n != null) {
                    this.classSection.setAnnotationSetRefListOffset(MethodKey, n);
                    continue;
                }
                dexDataWriter.align();
                int n2 = dexDataWriter.getPosition();
                this.classSection.setAnnotationSetRefListOffset(MethodKey, n2);
                hashMap.put(list, n2);
                ++this.numAnnotationSetRefItems;
                dexDataWriter.writeInt(list.size());
                for (Object AnnotationSetKey : list) {
                    if (this.annotationSetSection.getAnnotations(AnnotationSetKey).size() > 0) {
                        dexDataWriter.writeInt(this.annotationSetSection.getItemOffset(AnnotationSetKey));
                        continue;
                    }
                    if (this.shouldCreateEmptyAnnotationSet()) {
                        dexDataWriter.writeInt(this.annotationSetSectionOffset);
                        continue;
                    }
                    dexDataWriter.writeInt(0);
                }
            }
        }
    }

    private void writeAnnotationDirectories(DexDataWriter dexDataWriter) throws IOException {
        dexDataWriter.align();
        this.annotationDirectorySectionOffset = dexDataWriter.getPosition();
        HashMap hashMap = Maps.newHashMap();
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Comparable comparable : this.classSection.getSortedClasses()) {
            Object AnnotationSetKey;
            Collection collection = this.classSection.getSortedFields((Comparable)comparable);
            Collection collection2 = this.classSection.getSortedMethods((Comparable)comparable);
            int n = collection.size() * 8 + collection2.size() * 16;
            if (n > byteBuffer.capacity()) {
                byteBuffer = ByteBuffer.allocate(n);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            byteBuffer.clear();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Object object : collection) {
                AnnotationSetKey = this.classSection.getFieldAnnotations(object);
                if (AnnotationSetKey == null) continue;
                ++n2;
                byteBuffer.putInt(this.fieldSection.getFieldIndex(object));
                byteBuffer.putInt(this.annotationSetSection.getItemOffset(AnnotationSetKey));
            }
            for (Object object : collection2) {
                AnnotationSetKey = this.classSection.getMethodAnnotations(object);
                if (AnnotationSetKey == null) continue;
                ++n3;
                byteBuffer.putInt(this.methodSection.getMethodIndex(object));
                byteBuffer.putInt(this.annotationSetSection.getItemOffset(AnnotationSetKey));
            }
            for (Object object : collection2) {
                int n5 = this.classSection.getAnnotationSetRefListOffset(object);
                if (n5 == 0) continue;
                ++n4;
                byteBuffer.putInt(this.methodSection.getMethodIndex(object));
                byteBuffer.putInt(n5);
            }
            Iterator<Object> iterator = this.classSection.getClassAnnotations((Comparable)comparable);
            if (n2 == 0 && n3 == 0 && n4 == 0) {
                Object object;
                if (iterator == null) continue;
                object = (Integer)hashMap.get(iterator);
                if (object != null) {
                    this.classSection.setAnnotationDirectoryOffset((Comparable)comparable, (Integer)object);
                    continue;
                }
                hashMap.put(iterator, dexDataWriter.getPosition());
            }
            ++this.numAnnotationDirectoryItems;
            this.classSection.setAnnotationDirectoryOffset((Comparable)comparable, dexDataWriter.getPosition());
            dexDataWriter.writeInt(this.annotationSetSection.getNullableItemOffset(iterator));
            dexDataWriter.writeInt(n2);
            dexDataWriter.writeInt(n3);
            dexDataWriter.writeInt(n4);
            dexDataWriter.write(byteBuffer.array(), 0, byteBuffer.position());
        }
    }

    private void writeDebugAndCodeItems(DexDataWriter dexDataWriter, DeferredOutputStream deferredOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.debugSectionOffset = dexDataWriter.getPosition();
        DebugWriter debugWriter = new DebugWriter(this.stringSection, this.typeSection, dexDataWriter);
        DexDataWriter dexDataWriter2 = new DexDataWriter(deferredOutputStream, 0);
        ArrayList arrayList = Lists.newArrayList();
        for (Comparable object : this.classSection.getSortedClasses()) {
            Collection collection = this.classSection.getSortedDirectMethods((Comparable)object);
            Collection collection2 = this.classSection.getSortedVirtualMethods((Comparable)object);
            Iterable iterable = Iterables.concat(collection, collection2);
            for (Object MethodKey : iterable) {
                int n;
                int n2;
                List<TryBlock<ExceptionHandler>> list = this.classSection.getTryBlocks(MethodKey);
                Iterable iterable2 = this.classSection.getInstructions(MethodKey);
                Iterable<DebugItem> iterable3 = this.classSection.getDebugItems(MethodKey);
                if (iterable2 != null && this.stringSection.hasJumboIndexes()) {
                    n2 = 0;
                    for (Instruction instruction : iterable2) {
                        if (instruction.getOpcode() != Opcode.CONST_STRING || this.stringSection.getItemIndex((StringReference)((StringReference)((ReferenceInstruction)instruction).getReference())) < 65536) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        MutableMethodImplementation mutableMethodImplementation = this.classSection.makeMutableMethodImplementation(MethodKey);
                        this.fixInstructions(mutableMethodImplementation);
                        iterable2 = mutableMethodImplementation.getInstructions();
                        list = mutableMethodImplementation.getTryBlocks();
                        iterable3 = mutableMethodImplementation.getDebugItems();
                    }
                }
                n2 = this.writeDebugItem(dexDataWriter, debugWriter, this.classSection.getParameterNames(MethodKey), iterable3);
                try {
                    n = this.writeCodeItem(dexDataWriter2, byteArrayOutputStream, MethodKey, list, iterable2, n2);
                }
                catch (RuntimeException runtimeException) {
                    throw new ExceptionWithContext(runtimeException, "Exception occurred while writing code_item for method %s", this.methodSection.getMethodReference(MethodKey));
                }
                if (n == -1) continue;
                arrayList.add(new CodeItemOffset(MethodKey, n));
            }
        }
        dexDataWriter.align();
        this.codeSectionOffset = dexDataWriter.getPosition();
        dexDataWriter2.close();
        deferredOutputStream.writeTo(dexDataWriter);
        deferredOutputStream.close();
        for (CodeItemOffset codeItemOffset : arrayList) {
            this.classSection.setCodeItemOffset(codeItemOffset.method, this.codeSectionOffset + codeItemOffset.codeOffset);
        }
    }

    private void fixInstructions(MutableMethodImplementation mutableMethodImplementation) {
        Iterable iterable = mutableMethodImplementation.getInstructions();
        for (int i = 0; i < iterable.size(); ++i) {
            Instruction instruction = (Instruction)iterable.get(i);
            if (instruction.getOpcode() != Opcode.CONST_STRING || this.stringSection.getItemIndex((StringReference)((StringReference)((ReferenceInstruction)instruction).getReference())) < 65536) continue;
            mutableMethodImplementation.replaceInstruction(i, new BuilderInstruction31c(Opcode.CONST_STRING_JUMBO, ((OneRegisterInstruction)instruction).getRegisterA(), ((ReferenceInstruction)instruction).getReference()));
        }
    }

    private int writeDebugItem(DexDataWriter dexDataWriter, DebugWriter<StringKey, TypeKey> debugWriter, Iterable<? extends StringKey> iterable, Iterable<? extends DebugItem> iterable2) throws IOException {
        int n;
        int n2 = 0;
        int n3 = -1;
        if (iterable != null) {
            n2 = Iterables.size(iterable);
            n = 0;
            for (Object object : iterable) {
                if (object != null) {
                    n3 = n;
                }
                ++n;
            }
        }
        if (n3 == -1 && (iterable2 == null || Iterables.isEmpty(iterable2))) {
            return 0;
        }
        ++this.numDebugInfoItems;
        n = dexDataWriter.getPosition();
        int n4 = 0;
        if (iterable2 != null) {
            for (DebugItem object : iterable2) {
                if (!(object instanceof LineNumber)) continue;
                n4 = ((LineNumber)object).getLineNumber();
                break;
            }
        }
        dexDataWriter.writeUleb128(n4);
        dexDataWriter.writeUleb128(n2);
        if (iterable != null) {
            int n5 = 0;
            for (CharSequence charSequence : iterable) {
                if (n5 == n2) break;
                ++n5;
                dexDataWriter.writeUleb128(this.stringSection.getNullableItemIndex((CharSequence)charSequence) + 1);
            }
        }
        if (iterable2 != null) {
            debugWriter.reset(n4);
            for (DebugItem debugItem : iterable2) {
                this.classSection.writeDebugItem(debugWriter, debugItem);
            }
        }
        dexDataWriter.write(0);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int writeCodeItem(DexDataWriter dexDataWriter, ByteArrayOutputStream byteArrayOutputStream, MethodKey MethodKey, List<? extends TryBlock<? extends ExceptionHandler>> list, Iterable<? extends Instruction> iterable, int n) throws IOException {
        if (iterable == null && n == 0) {
            return -1;
        }
        ++this.numCodeItemItems;
        dexDataWriter.align();
        int n2 = dexDataWriter.getPosition();
        dexDataWriter.writeUshort(this.classSection.getRegisterCount(MethodKey));
        boolean bl = AccessFlags.STATIC.isSet(this.classSection.getMethodAccessFlags(MethodKey));
        Collection collection = this.typeListSection.getTypes(this.protoSection.getParameters(this.methodSection.getPrototype(MethodKey)));
        dexDataWriter.writeUshort(MethodUtil.getParameterRegisterCount(collection, bl));
        if (iterable != null) {
            int n3;
            HashMap<List<ExceptionHandler>, Integer> hashMap;
            list = TryListBuilder.massageTryBlocks(list);
            int n4 = 0;
            int n5 = 0;
            for (Instruction instruction : iterable) {
                n5 += instruction.getCodeUnits();
                if (instruction.getOpcode().referenceType != 3) continue;
                hashMap = (ReferenceInstruction)instruction;
                MethodReference methodReference = (MethodReference)hashMap.getReference();
                Opcode opcode = instruction.getOpcode();
                n3 = InstructionUtil.isInvokePolymorphic(opcode) ? ((VariableRegisterInstruction)instruction).getRegisterCount() : MethodUtil.getParameterRegisterCount(methodReference, InstructionUtil.isInvokeStatic(opcode));
                if (n3 <= n4) continue;
                n4 = n3;
            }
            dexDataWriter.writeUshort(n4);
            dexDataWriter.writeUshort(list.size());
            dexDataWriter.writeInt(n);
            InstructionWriter instructionWriter = InstructionWriter.makeInstructionWriter(this.opcodes, dexDataWriter, this.stringSection, this.typeSection, this.fieldSection, this.methodSection, this.protoSection, this.methodHandleSection, this.callSiteSection);
            dexDataWriter.writeInt(n5);
            boolean n6 = false;
            for (Instruction instruction : iterable) {
                try {
                    switch (instruction.getOpcode().format) {
                        case Format10t: {
                            instructionWriter.write((Instruction10t)instruction);
                            break;
                        }
                        case Format10x: {
                            instructionWriter.write((Instruction10x)instruction);
                            break;
                        }
                        case Format11n: {
                            instructionWriter.write((Instruction11n)instruction);
                            break;
                        }
                        case Format11x: {
                            instructionWriter.write((Instruction11x)instruction);
                            break;
                        }
                        case Format12x: {
                            instructionWriter.write((Instruction12x)instruction);
                            break;
                        }
                        case Format20bc: {
                            instructionWriter.write((Instruction20bc)instruction);
                            break;
                        }
                        case Format20t: {
                            instructionWriter.write((Instruction20t)instruction);
                            break;
                        }
                        case Format21c: {
                            instructionWriter.write((Instruction21c)instruction);
                            break;
                        }
                        case Format21ih: {
                            instructionWriter.write((Instruction21ih)instruction);
                            break;
                        }
                        case Format21lh: {
                            instructionWriter.write((Instruction21lh)instruction);
                            break;
                        }
                        case Format21s: {
                            instructionWriter.write((Instruction21s)instruction);
                            break;
                        }
                        case Format21t: {
                            instructionWriter.write((Instruction21t)instruction);
                            break;
                        }
                        case Format22b: {
                            instructionWriter.write((Instruction22b)instruction);
                            break;
                        }
                        case Format22c: {
                            instructionWriter.write((Instruction22c)instruction);
                            break;
                        }
                        case Format22cs: {
                            instructionWriter.write((Instruction22cs)instruction);
                            break;
                        }
                        case Format22s: {
                            instructionWriter.write((Instruction22s)instruction);
                            break;
                        }
                        case Format22t: {
                            instructionWriter.write((Instruction22t)instruction);
                            break;
                        }
                        case Format22x: {
                            instructionWriter.write((Instruction22x)instruction);
                            break;
                        }
                        case Format23x: {
                            instructionWriter.write((Instruction23x)instruction);
                            break;
                        }
                        case Format30t: {
                            instructionWriter.write((Instruction30t)instruction);
                            break;
                        }
                        case Format31c: {
                            instructionWriter.write((Instruction31c)instruction);
                            break;
                        }
                        case Format31i: {
                            instructionWriter.write((Instruction31i)instruction);
                            break;
                        }
                        case Format31t: {
                            instructionWriter.write((Instruction31t)instruction);
                            break;
                        }
                        case Format32x: {
                            instructionWriter.write((Instruction32x)instruction);
                            break;
                        }
                        case Format35c: {
                            instructionWriter.write((Instruction35c)instruction);
                            break;
                        }
                        case Format35mi: {
                            instructionWriter.write((Instruction35mi)instruction);
                            break;
                        }
                        case Format35ms: {
                            instructionWriter.write((Instruction35ms)instruction);
                            break;
                        }
                        case Format3rc: {
                            instructionWriter.write((Instruction3rc)instruction);
                            break;
                        }
                        case Format3rmi: {
                            instructionWriter.write((Instruction3rmi)instruction);
                            break;
                        }
                        case Format3rms: {
                            instructionWriter.write((Instruction3rms)instruction);
                            break;
                        }
                        case Format45cc: {
                            instructionWriter.write((Instruction45cc)instruction);
                            break;
                        }
                        case Format4rcc: {
                            instructionWriter.write((Instruction4rcc)instruction);
                            break;
                        }
                        case Format51l: {
                            instructionWriter.write((Instruction51l)instruction);
                            break;
                        }
                        case ArrayPayload: {
                            instructionWriter.write((ArrayPayload)instruction);
                            break;
                        }
                        case PackedSwitchPayload: {
                            instructionWriter.write((PackedSwitchPayload)instruction);
                            break;
                        }
                        case SparseSwitchPayload: {
                            instructionWriter.write((SparseSwitchPayload)instruction);
                            break;
                        }
                        default: {
                            throw new ExceptionWithContext("Unsupported instruction format: %s", new Object[]{instruction.getOpcode().format});
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    void var13_15;
                    throw new ExceptionWithContext(runtimeException, "Error while writing instruction at code offset 0x%x", (int)var13_15);
                }
                var13_15 += instruction.getCodeUnits();
            }
            if (list.size() > 0) {
                dexDataWriter.align();
                hashMap = Maps.newHashMap();
                for (TryBlock<ExceptionHandler> tryBlock : list) {
                    hashMap.put(tryBlock.getExceptionHandlers(), 0);
                }
                DexDataWriter.writeUleb128(byteArrayOutputStream, hashMap.size());
                for (TryBlock<ExceptionHandler> tryBlock : list) {
                    n3 = tryBlock.getStartCodeAddress();
                    int n7 = n3 + tryBlock.getCodeUnitCount();
                    int n8 = n7 - n3;
                    dexDataWriter.writeInt(n3);
                    dexDataWriter.writeUshort(n8);
                    if (tryBlock.getExceptionHandlers().size() == 0) {
                        throw new ExceptionWithContext("No exception handlers for the try block!", new Object[0]);
                    }
                    Integer n9 = (Integer)hashMap.get(tryBlock.getExceptionHandlers());
                    if (n9 != 0) {
                        dexDataWriter.writeUshort(n9);
                        continue;
                    }
                    n9 = byteArrayOutputStream.size();
                    dexDataWriter.writeUshort(n9);
                    hashMap.put(tryBlock.getExceptionHandlers(), n9);
                    int n10 = tryBlock.getExceptionHandlers().size();
                    ExceptionHandler exceptionHandler = tryBlock.getExceptionHandlers().get(n10 - 1);
                    if (exceptionHandler.getExceptionType() == null) {
                        n10 = n10 * -1 + 1;
                    }
                    DexDataWriter.writeSleb128(byteArrayOutputStream, n10);
                    for (ExceptionHandler exceptionHandler2 : tryBlock.getExceptionHandlers()) {
                        Object TypeKey = this.classSection.getExceptionType(exceptionHandler2);
                        int n11 = exceptionHandler2.getHandlerCodeAddress();
                        if (TypeKey != null) {
                            DexDataWriter.writeUleb128(byteArrayOutputStream, this.typeSection.getItemIndex(TypeKey));
                            DexDataWriter.writeUleb128(byteArrayOutputStream, n11);
                            continue;
                        }
                        DexDataWriter.writeUleb128(byteArrayOutputStream, n11);
                    }
                }
                if (byteArrayOutputStream.size() > 0) {
                    byteArrayOutputStream.writeTo(dexDataWriter);
                    byteArrayOutputStream.reset();
                }
            }
        } else {
            dexDataWriter.writeUshort(0);
            dexDataWriter.writeUshort(0);
            dexDataWriter.writeInt(n);
            dexDataWriter.writeInt(0);
        }
        return n2;
    }

    private int calcNumItems() {
        int n = 0;
        ++n;
        if (this.stringSection.getItems().size() > 0) {
            n += 2;
        }
        if (this.typeSection.getItems().size() > 0) {
            ++n;
        }
        if (this.protoSection.getItems().size() > 0) {
            ++n;
        }
        if (this.fieldSection.getItems().size() > 0) {
            ++n;
        }
        if (this.methodSection.getItems().size() > 0) {
            ++n;
        }
        if (this.callSiteSection.getItems().size() > 0) {
            ++n;
        }
        if (this.methodHandleSection.getItems().size() > 0) {
            ++n;
        }
        if (this.typeListSection.getItems().size() > 0) {
            ++n;
        }
        if (this.encodedArraySection.getItems().size() > 0) {
            ++n;
        }
        if (this.annotationSection.getItems().size() > 0) {
            ++n;
        }
        if (this.annotationSetSection.getItems().size() > 0 || this.shouldCreateEmptyAnnotationSet()) {
            ++n;
        }
        if (this.numAnnotationSetRefItems > 0) {
            ++n;
        }
        if (this.numAnnotationDirectoryItems > 0) {
            ++n;
        }
        if (this.numDebugInfoItems > 0) {
            ++n;
        }
        if (this.numCodeItemItems > 0) {
            ++n;
        }
        if (this.classSection.getItems().size() > 0) {
            ++n;
        }
        if (this.numClassDataItems > 0) {
            ++n;
        }
        return ++n;
    }

    private void writeMapItem(DexDataWriter dexDataWriter) throws IOException {
        dexDataWriter.align();
        this.mapSectionOffset = dexDataWriter.getPosition();
        int n = this.calcNumItems();
        dexDataWriter.writeInt(n);
        this.writeMapItem(dexDataWriter, 0, 1, 0);
        this.writeMapItem(dexDataWriter, 1, this.stringSection.getItems().size(), this.stringIndexSectionOffset);
        this.writeMapItem(dexDataWriter, 2, this.typeSection.getItems().size(), this.typeSectionOffset);
        this.writeMapItem(dexDataWriter, 3, this.protoSection.getItems().size(), this.protoSectionOffset);
        this.writeMapItem(dexDataWriter, 4, this.fieldSection.getItems().size(), this.fieldSectionOffset);
        this.writeMapItem(dexDataWriter, 5, this.methodSection.getItems().size(), this.methodSectionOffset);
        this.writeMapItem(dexDataWriter, 6, this.classSection.getItems().size(), this.classIndexSectionOffset);
        this.writeMapItem(dexDataWriter, 7, this.callSiteSection.getItems().size(), this.callSiteSectionOffset);
        this.writeMapItem(dexDataWriter, 8, this.methodHandleSection.getItems().size(), this.methodHandleSectionOffset);
        this.writeMapItem(dexDataWriter, 8194, this.stringSection.getItems().size(), this.stringDataSectionOffset);
        this.writeMapItem(dexDataWriter, 4097, this.typeListSection.getItems().size(), this.typeListSectionOffset);
        this.writeMapItem(dexDataWriter, 8197, this.encodedArraySection.getItems().size(), this.encodedArraySectionOffset);
        this.writeMapItem(dexDataWriter, 8196, this.annotationSection.getItems().size(), this.annotationSectionOffset);
        this.writeMapItem(dexDataWriter, 4099, this.annotationSetSection.getItems().size() + (this.shouldCreateEmptyAnnotationSet() ? 1 : 0), this.annotationSetSectionOffset);
        this.writeMapItem(dexDataWriter, 4098, this.numAnnotationSetRefItems, this.annotationSetRefSectionOffset);
        this.writeMapItem(dexDataWriter, 8198, this.numAnnotationDirectoryItems, this.annotationDirectorySectionOffset);
        this.writeMapItem(dexDataWriter, 8195, this.numDebugInfoItems, this.debugSectionOffset);
        this.writeMapItem(dexDataWriter, 8193, this.numCodeItemItems, this.codeSectionOffset);
        this.writeMapItem(dexDataWriter, 8192, this.numClassDataItems, this.classDataSectionOffset);
        this.writeMapItem(dexDataWriter, 4096, 1, this.mapSectionOffset);
    }

    private void writeMapItem(DexDataWriter dexDataWriter, int n, int n2, int n3) throws IOException {
        if (n2 > 0) {
            dexDataWriter.writeUshort(n);
            dexDataWriter.writeUshort(0);
            dexDataWriter.writeInt(n2);
            dexDataWriter.writeInt(n3);
        }
    }

    private void writeHeader(DexDataWriter dexDataWriter, int n, int n2) throws IOException {
        dexDataWriter.write(HeaderItem.getMagicForApi(this.opcodes.api));
        dexDataWriter.writeInt(0);
        dexDataWriter.write(new byte[20]);
        dexDataWriter.writeInt(n2);
        dexDataWriter.writeInt(112);
        dexDataWriter.writeInt(305419896);
        dexDataWriter.writeInt(0);
        dexDataWriter.writeInt(0);
        dexDataWriter.writeInt(this.mapSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.stringSection.getItems().size(), this.stringIndexSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.typeSection.getItems().size(), this.typeSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.protoSection.getItems().size(), this.protoSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.fieldSection.getItems().size(), this.fieldSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.methodSection.getItems().size(), this.methodSectionOffset);
        this.writeSectionInfo(dexDataWriter, this.classSection.getItems().size(), this.classIndexSectionOffset);
        dexDataWriter.writeInt(n2 - n);
        dexDataWriter.writeInt(n);
    }

    private void writeSectionInfo(DexDataWriter dexDataWriter, int n, int n2) throws IOException {
        dexDataWriter.writeInt(n);
        if (n > 0) {
            dexDataWriter.writeInt(n2);
        } else {
            dexDataWriter.writeInt(0);
        }
    }

    private boolean shouldCreateEmptyAnnotationSet() {
        return this.opcodes.api < 17;
    }

    public abstract class SectionProvider {
        public abstract StringSectionType getStringSection();

        public abstract TypeSectionType getTypeSection();

        public abstract ProtoSectionType getProtoSection();

        public abstract FieldSectionType getFieldSection();

        public abstract MethodSectionType getMethodSection();

        public abstract ClassSectionType getClassSection();

        public abstract CallSiteSectionType getCallSiteSection();

        public abstract MethodHandleSectionType getMethodHandleSection();

        public abstract TypeListSectionType getTypeListSection();

        public abstract AnnotationSectionType getAnnotationSection();

        public abstract AnnotationSetSectionType getAnnotationSetSection();

        public abstract EncodedArraySectionType getEncodedArraySection();
    }

    private static class CodeItemOffset<MethodKey> {
        MethodKey method;
        int codeOffset;

        private CodeItemOffset(MethodKey MethodKey, int n) {
            this.codeOffset = n;
            this.method = MethodKey;
        }
    }

    protected class InternalEncodedValueWriter
    extends EncodedValueWriter<StringKey, TypeKey, FieldRefKey, MethodRefKey, AnnotationElement, ProtoRefKey, MethodHandleKey, EncodedValue> {
        private InternalEncodedValueWriter(DexDataWriter dexDataWriter) {
            super(dexDataWriter, DexWriter.this.stringSection, DexWriter.this.typeSection, DexWriter.this.fieldSection, DexWriter.this.methodSection, DexWriter.this.protoSection, DexWriter.this.methodHandleSection, DexWriter.this.annotationSection);
        }

        @Override
        protected void writeEncodedValue(EncodedValue EncodedValue2) throws IOException {
            DexWriter.this.writeEncodedValue(this, EncodedValue2);
        }
    }
}

