/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DexOpener {
    private static final String[] REFUSED_PACKAGES = new String[]{"com.github.tmurakami.dexopener.", "android.", "androidx.", "com.android.", "com.google.android.", "com.sun.", "dalvik.", "java.", "javax.", "libcore.", "org.apache.commons.logging.", "org.apache.harmony.", "org.apache.http.", "org.ccil.cowan.tagsoup.", "org.json.", "org.kxml2.io.", "org.w3c.dom.", "org.xml.sax.", "org.xmlpull.v1.", "sun.", "junit.", "org.hamcrest.", "org.junit."};

    private DexOpener() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Object pkg;
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalStateException("The Instrumentation instance has not yet been initialized");
        }
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("An Application instance has already been created");
        }
        Object rootPackage = null;
        String instrumentationName = instrumentation.getClass().getName();
        int lastDotPos = instrumentationName.lastIndexOf(46);
        if (lastDotPos != -1 && ((String)(pkg = instrumentationName.substring(0, lastDotPos))).indexOf(46) != -1) {
            rootPackage = pkg;
        }
        if (rootPackage == null) {
            throw new IllegalArgumentException("The package of the given Instrumentation instance must have at least one '.' separator: " + instrumentationName);
        }
        for (String pkg2 : REFUSED_PACKAGES) {
            if (!((String)rootPackage).startsWith(pkg2)) continue;
            throw new UnsupportedOperationException("Manipulating an Instrumentation instance belonging to the '" + (String)rootPackage + "' package is not supported");
        }
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("The package to be opened: " + (String)rootPackage + ".**");
        }
        DexOpener.install(context, new AndroidClassSourceFactory(new ClassNameFilter((String)rootPackage + '.').excludeClasses(instrumentationName)));
    }

    @VisibleForTesting
    static void install(Context context, AndroidClassSourceFactory androidClassSourceFactory) {
        ApplicationInfo ai = context.getApplicationInfo();
        File parentDir = Build.VERSION.SDK_INT < 21 ? new File(ai.dataDir, "code_cache") : context.getCodeCacheDir();
        File cacheDir = new File(parentDir, "dexopener");
        if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassSource classSource = androidClassSourceFactory.newClassSource(ai.sourceDir, cacheDir);
        ClassInjector.from((ClassSource)classSource).into(context.getClassLoader());
    }
}

