/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.android.DexClassFile;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;

final class DexClassSource
implements ClassSource {
    private final Map<String, RunnableFuture<DexFile>> futureMap;

    DexClassSource(Map<String, RunnableFuture<DexFile>> futureMap) {
        this.futureMap = futureMap;
    }

    public ClassFile getClassFile(String className) throws IOException {
        RunnableFuture<DexFile> future = this.futureMap.get(className);
        if (future == null) {
            return null;
        }
        future.run();
        boolean interrupted = false;
        while (true) {
            try {
                DexClassFile dexClassFile = new DexClassFile(className, (DexFile)future.get());
                return dexClassFile;
            }
            catch (InterruptedException e) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e2) {
                    Throwable cause = e2.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new UndeclaredThrowableException(cause, "Unexpected error");
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

