/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.classinjector.android;

import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassFile;
import dalvik.system.DexFile;
import java.util.Enumeration;

public final class DexClassFile
implements ClassFile {
    private final String className;
    private final DexFile dexFile;

    public DexClassFile(@NonNull String className, @NonNull DexFile dexFile) {
        if (className.isEmpty()) {
            throw new IllegalArgumentException("'className' is empty");
        }
        Enumeration e = dexFile.entries();
        while (e.hasMoreElements()) {
            if (!className.equals(e.nextElement())) continue;
            this.className = className;
            this.dexFile = dexFile;
            return;
        }
        throw new IllegalArgumentException("'dexFile' does not contain data making up class " + className);
    }

    @NonNull
    public Class toClass(@NonNull ClassLoader classLoader) {
        return this.dexFile.loadClass(this.className, classLoader);
    }
}

