/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.video.internal;

import br.tiagohm.markdownview.ext.video.VideoLink;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class VideoLinkNodePostProcessor
extends NodePostProcessor {
    public VideoLinkNodePostProcessor(DataHolder options) {
    }

    public void process(NodeTracker state, Node node) {
        BasedSequence chars;
        Node previous;
        if (node instanceof Link && (previous = node.getPrevious()) instanceof Text && (chars = previous.getChars()).endsWith((CharSequence)"@") && chars.isContinuedBy(node.getChars())) {
            previous.setChars(chars.subSequence(0, chars.length() - 1));
            VideoLink videoLink = new VideoLink((Link)node);
            videoLink.takeChildren(node);
            node.unlink();
            previous.insertAfter((Node)videoLink);
            state.nodeRemoved(node);
            state.nodeAddedWithChildren((Node)videoLink);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory(DataHolder options) {
            super(false);
            this.addNodes(new Class[]{Link.class});
        }

        public NodePostProcessor create(Document document) {
            return new VideoLinkNodePostProcessor((DataHolder)document);
        }
    }
}

