/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.video.internal;

import android.text.TextUtils;
import br.tiagohm.markdownview.ext.video.VideoLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class VideoLinkNodeRenderer
implements NodeRenderer {
    public VideoLinkNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(VideoLink.class, (CustomNodeRenderer)new CustomNodeRenderer<VideoLink>(){

            public void render(VideoLink node, NodeRendererContext context, HtmlWriter html) {
                VideoLinkNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(VideoLink node, NodeRendererContext context, HtmlWriter html) {
        String name = node.getText().toString();
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else if (!TextUtils.isEmpty((CharSequence)name)) {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null);
            if (name.equals("youtube") || name.equals("yt")) {
                html.attr((CharSequence)"class", (CharSequence)"player yt-player");
                html.withAttr().tag((CharSequence)"div");
                html.attr((CharSequence)"type", (CharSequence)"text/html");
                html.attr((CharSequence)"frameborder", (CharSequence)"0");
                html.attr((CharSequence)"allowfullscreen", (CharSequence)"");
                html.attr((CharSequence)"src", (CharSequence)String.format("https://www.youtube.com/embed/%s", resolvedLink.getUrl()));
                html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"iframe");
                html.tag((CharSequence)"/iframe");
                html.tag((CharSequence)"/div");
            } else {
                context.renderChildren((Node)node);
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new VideoLinkNodeRenderer(options);
        }
    }
}

