/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;

public class TestClients {
    public static Map<String, Object> createJaas(String user, String password) {
        return Map.of("sasl.mechanism", "PLAIN", "security.protocol", "SASL_PLAINTEXT", "sasl.jaas.config", SecurityConfigs.plainJaas(user, password));
    }

    public static Producer<String, String> createProducer(String bootstrapServer) {
        return TestClients.createProducer(bootstrapServer, Collections.emptyMap());
    }

    public static Producer<String, String> createProducer(String bootstrapServer, Map<String, Object> addProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", bootstrapServer);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        props.put("max.block.ms", 5000);
        props.putAll(addProps);
        return new KafkaProducer(props);
    }

    public static TestConsumer<String, String> createConsumer(String bootstrapServer) {
        return TestClients.createConsumer(bootstrapServer, Collections.emptyMap());
    }

    static Map<String, Object> getCommonConsumerProps(String bootstrap) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", bootstrap);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("group.id", "test-group");
        props.put("auto.offset.reset", "earliest");
        return props;
    }

    public static TestConsumer<String, String> createConsumer(String bootstrapServer, Map<String, Object> addProps) {
        Map<String, Object> props = TestClients.getCommonConsumerProps(bootstrapServer);
        props.put("value.deserializer", StringDeserializer.class);
        props.putAll(addProps);
        return new TestConsumer<String, String>(props);
    }

    public static TestConsumer<String, GenericRecord> createAvroConsumer(String bootstrapServer, String schemaRegistryUrl) {
        return TestClients.createAvroConsumer(bootstrapServer, schemaRegistryUrl, Collections.emptyMap());
    }

    public static TestConsumer<String, GenericRecord> createAvroConsumer(String bootstrapServer, String schemaRegistryUrl, Map<String, Object> addProps) {
        Map<String, Object> props = TestClients.getCommonConsumerProps(bootstrapServer);
        props.put("value.deserializer", KafkaAvroDeserializer.class);
        props.put("schema.registry.url", schemaRegistryUrl);
        props.putAll(addProps);
        return new TestConsumer<String, GenericRecord>(props);
    }

    public static Producer<String, GenericRecord> createAvroProducer(String bootstrapServer, String schemaRegistryUrl) {
        return TestClients.createAvroProducer(bootstrapServer, schemaRegistryUrl, Collections.emptyMap());
    }

    public static Producer<String, GenericRecord> createAvroProducer(String bootstrapServer, String schemaRegistryUrl, Map<String, Object> addProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", bootstrapServer);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        props.put("schema.registry.url", schemaRegistryUrl);
        props.put("max.block.ms", 5000);
        props.putAll(addProps);
        return new KafkaProducer(props);
    }

    public static void basicReadWriteTest(String bootStrapServer) {
        Producer<String, String> producer = TestClients.createProducer(bootStrapServer);
        String topic = "test-topic";
        String value = "hello-world";
        try {
            producer.send(new ProducerRecord("test-topic", (Object)"hello-world")).get();
            TestConsumer<String, String> consumer = TestClients.createConsumer(bootStrapServer);
            consumer.subscribe(Set.of("test-topic"));
            List<String> results = consumer.consumeUntil(1);
            System.out.println("RESULTS " + results);
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)"hello-world", (Object)results.get(0));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Basic Kafka test failed", e);
        }
    }

    public static class TestConsumer<K, V>
    extends KafkaConsumer<K, V> {
        public TestConsumer(Map<String, Object> configs) {
            super(configs);
        }

        public List<V> consumeUntil(int maxRecords) {
            return this.consumeUntil(maxRecords, Duration.ofSeconds(1L), 60);
        }

        public List<V> consumeUntil(int maxRecords, Duration timeout, int tries) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < tries; ++i) {
                ConsumerRecords records = this.poll(timeout);
                for (ConsumerRecord r : records) {
                    results.add(r.value());
                    if (results.size() < maxRecords) continue;
                    return results;
                }
            }
            return results;
        }
    }
}

