/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.christophschubert.cp.testcontainers.CPTestContainerFactory;
import net.christophschubert.cp.testcontainers.ConfluentServerContainer;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class SalsPlainDecorator {
    Map<String, String> userAndPasswords = Collections.emptyMap();
    List<String> additionalSuperUsers = Collections.emptyList();

    public SalsPlainDecorator(Map<String, String> userAndPasswords, List<String> additionalSuperUsers) {
        this.userAndPasswords = userAndPasswords;
        this.additionalSuperUsers = additionalSuperUsers;
    }

    public SalsPlainDecorator(Map<String, String> userAndPasswords) {
        this.userAndPasswords = userAndPasswords;
    }

    public SalsPlainDecorator() {
    }

    String getAuthorizer(KafkaContainer container) {
        if (container instanceof ConfluentServerContainer) {
            return "io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer";
        }
        String tag = DockerImageName.parse((String)container.getDockerImageName()).getVersionPart();
        return tag.compareTo("5.4.0") < 0 ? "kafka.security.auth.SimpleAclAuthorizer" : "kafka.security.authorizer.AclAuthorizer";
    }

    public <T extends KafkaContainer> T addSaslPlainConfig(T container) {
        return this.addSaslPlainConfig(container, false);
    }

    public <T extends KafkaContainer> T addSaslPlainConfig(T container, boolean enableAuthorizationViaAcls) {
        String admin = "admin";
        String adminSecret = "admin-secret";
        HashMap<String, String> userInfo = new HashMap<String, String>(this.userAndPasswords);
        userInfo.put("admin", "admin-secret");
        ArrayList<String> superUsers = new ArrayList<String>(this.additionalSuperUsers);
        superUsers.add("admin");
        ((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)container.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "PLAINTEXT:SASL_PLAINTEXT,BROKER:SASL_PLAINTEXT")).withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER")).withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "PLAIN")).withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_SASL_ENABLED_MECHANISMS", "PLAIN")).withEnv("KAFKA_LISTENER_NAME_BROKER_SASL_ENABLED_MECHANISMS", "PLAIN")).withEnv("KAFKA_LISTENER_NAME_BROKER_PLAIN_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret", Map.of("admin", "admin-secret")))).withEnv("KAFKA_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret", Collections.emptyMap()))).withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_PLAIN_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret", userInfo));
        if (enableAuthorizationViaAcls) {
            String su = superUsers.stream().map(s -> "User:" + s).collect(Collectors.joining(";"));
            ((KafkaContainer)container.withEnv(CPTestContainerFactory.pToEKafka("authorizer.class.name"), this.getAuthorizer(container))).withEnv(CPTestContainerFactory.pToEKafka("super.users"), su);
        }
        return container;
    }
}

