/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import net.christophschubert.cp.testcontainers.CPTestContainer;
import net.christophschubert.cp.testcontainers.KafkaConnectContainer;
import net.christophschubert.cp.testcontainers.SchemaRegistryContainer;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class KsqlDBContainer
extends CPTestContainer<KsqlDBContainer> {
    static final int defaultPort = 8088;

    KsqlDBContainer(DockerImageName dockerImageName, KafkaContainer bootstrap, Network network) {
        super(dockerImageName, bootstrap, network, 8088, "KSQL");
        this.withProperty("host.name", "ksqldb-server");
        this.withProperty("bootstrap.servers", KsqlDBContainer.getInternalBootstrap(bootstrap));
        this.withProperty("listeners", this.getHttpPortListener());
        this.withEnv("KSQL_CACHE_MAX_BYTES_BUFFERING", "0");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/").forStatusCode(200).forStatusCode(401));
    }

    public KsqlDBContainer withServiceId(String serviceId) {
        this.withEnv("KSQL_KSQL_SERVICE_ID", serviceId);
        return this;
    }

    public KsqlDBContainer withQueriesFile(String queriesFile) {
        String containerPath = "/queries.sql";
        this.withCopyFileToContainer(MountableFile.forHostPath((String)queriesFile), "/queries.sql");
        this.withEnv("KSQL_KSQL_QUERIES_FILE", "/queries.sql");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*INFO Server up and running.*", (int)1));
        return this;
    }

    public KsqlDBContainer withSchemaRegistry(SchemaRegistryContainer schemaRegistry) {
        this.withEnv("KSQL_KSQL_SCHEMA_REGISTRY_URL", schemaRegistry.getInternalBaseUrl());
        this.dependsOn(new Startable[]{schemaRegistry});
        return this;
    }

    public KsqlDBContainer withConnect(KafkaConnectContainer connectContainer) {
        this.withEnv("KSQL_KSQL_CONNECT_URL", connectContainer.getInternalBaseUrl());
        this.dependsOn(new Startable[]{connectContainer});
        return this;
    }

    public KsqlDBContainer enableRbac(String mdsBootstrap, String ksqlPrincipal, String ksqlSecret) {
        this.prepareCertificates();
        this.withEnv("CUB_CLASSPATH", "/usr/share/java/confluent-security/ksql/*:/usr/share/java/ksqldb-server/*:/usr/share/java/cp-base-new/*");
        this.withProperty("ksql.security.extension.class", "io.confluent.ksql.security.KsqlConfluentSecurityExtension");
        this.withProperties(SecurityConfigs.oAuthWithTokenCallbackHandlerProperties(ksqlPrincipal, ksqlSecret, mdsBootstrap));
        this.withProperty("rest.servlet.initializor.classes", "io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler");
        this.withProperty("websocket.servlet.initializor.classes", "io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler");
        this.withProperty("oauth.jwt.public.key.path", this.getPublicKeyPath());
        this.withProperty("confluent.metadata.public.key.path", this.getPublicKeyPath());
        this.withProperty("ksql.authentication.plugin.class", "io.confluent.ksql.security.VertxBearerOrBasicAuthenticationPlugin");
        this.withProperty("confluent.schema.registry.authorizer.class", "io.confluent.kafka.schemaregistry.security.authorizer.rbac.RbacAuthorizer");
        this.withProperty("rest.servlet.initializor.classes", "io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler");
        this.withProperties(SecurityConfigs.confluentMdsSettings(ksqlPrincipal, ksqlSecret, mdsBootstrap));
        this.withProperty("public.key.path", this.getPublicKeyPath());
        this.withProperty("confluent.metadata.basic.auth.credentials.provider", "USER_INFO");
        this.withProperty("ksql.schema.registry.basic.auth.credentials.source", "USER_INFO");
        this.withProperty("ksql.schema.registry.basic.auth.user.info", ksqlPrincipal + ":" + ksqlSecret);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*INFO Server up and running.*", (int)1));
        return this;
    }

    @Override
    public CPTestContainer<KsqlDBContainer> withLogLevel(String logLevel) {
        this.withEnv("KSQL_LOG4J_ROOT_LOGLEVEL", logLevel);
        return this;
    }
}

