/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import net.christophschubert.cp.testcontainers.CPTestContainerFactory;
import net.christophschubert.cp.testcontainers.KafkaContainerTools;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class ConfluentServerContainer
extends KafkaContainer {
    final int mdsPort = 8090;
    final String admin = "admin";
    final String adminSecret = "admin-secret";

    public ConfluentServerContainer(String repository, String tag) {
        super(DockerImageName.parse((String)(repository + "/cp-server:" + tag)).asCompatibleSubstituteFor(repository + "/cp-kafka"));
        this.withExposedPorts(new Integer[]{8090, 9093});
        this.withStartupTimeout(Duration.ofMinutes(4L));
        KafkaContainerTools.adjustReplicationFactors(this, 1);
        this.setReplicationFactors(1);
        this.withProperty("confluent.telemetry.enabled", false);
        this.withProperty("confluent.metrics.enabled", false);
        this.withProperty("confluent.balancer.enable", false);
    }

    ConfluentServerContainer setReplicationFactors(int rf) {
        this.withProperty("confluent.metadata.topic.replication.factor", rf);
        this.withProperty("confluent.license.topic.replication.factor", rf);
        this.withEnv("KAFKA_CONFLUENT_BALANCER_TOPIC_REPLICATION_FACTOR", "" + rf);
        this.withEnv("CONFLUENT_METRICS_REPORTER_TOPIC_REPLICAS", "" + rf);
        return this;
    }

    ConfluentServerContainer withProperty(String property, Object value) {
        Objects.requireNonNull(value);
        String envVar = "KAFKA_" + property.replace('.', '_').toUpperCase();
        this.withEnv(envVar, value.toString());
        return this;
    }

    public int getMdsPort() {
        return this.getMappedPort(8090);
    }

    public String getMdsUrl() {
        return String.format("http://%s:%d", this.getNetworkAliases().get(0), 8090);
    }

    public ConfluentServerContainer enableRbac() {
        String containerCertPath = "/tmp/conf";
        String localCertPath = "src/main/resources/certs";
        String brokerNetworkAlias = this.getHost();
        this.withFileSystemBind("src/main/resources/certs", "/tmp/conf");
        this.withProperty("super.users", "User:admin;User:mds;User:alice");
        this.withProperty("listener.security.protocol.map", "PLAINTEXT:SASL_PLAINTEXT,BROKER:SASL_PLAINTEXT");
        this.withProperty("confluent.metadata.security.protocol", "SASL_PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "PLAIN");
        this.withEnv("KAFKA_LISTENER_NAME_BROKER_SASL_ENABLED_MECHANISMS", "PLAIN,OAUTHBEARER");
        this.withEnv("KAFKA_LISTENER_NAME_BROKER_PLAIN_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret", Map.of("admin", "admin-secret", "mds", "mds-secret")));
        this.withEnv(CPTestContainerFactory.pToEKafka("listener.name.broker.oauthbearer.sasl.server.callback.handler.class"), "io.confluent.kafka.server.plugins.auth.token.TokenBearerValidatorCallbackHandler");
        this.withEnv(CPTestContainerFactory.pToEKafka("listener.name.broker.oauthbearer.sasl.login.callback.handler.class"), "io.confluent.kafka.server.plugins.auth.token.TokenBearerServerLoginCallbackHandler");
        this.withEnv(CPTestContainerFactory.pToEKafka("listener.name.broker.oauthbearer.sasl.jaas.config"), String.format("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"%s\";", "/tmp/conf/public.pem"));
        this.withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_SASL_ENABLED_MECHANISMS", "PLAIN");
        this.withEnv(CPTestContainerFactory.pToEKafka("listener.name.plaintext.plain.sasl.server.callback.handler.class"), "io.confluent.security.auth.provider.ldap.LdapAuthenticateCallbackHandler");
        this.withEnv("KAFKA_LISTENER_NAME_PLAINTEXT_PLAIN_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret"));
        this.withEnv(CPTestContainerFactory.pToEKafka("authorizer.class.name"), "io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer");
        this.withEnv(CPTestContainerFactory.pToEKafka("confluent.metadata.bootstrap.servers"), String.format("BROKER://%s:9092", brokerNetworkAlias));
        this.withEnv(CPTestContainerFactory.pToEKafka("confluent.metadata.sasl.mechanism"), "PLAIN");
        this.withEnv(CPTestContainerFactory.pToEKafka("confluent.metadata.sasl.jaas.config"), SecurityConfigs.plainJaas("mds", "mds-secret"));
        this.withEnv(this.mdsPrefix("authentication.method"), "BEARER");
        this.withEnv(this.mdsPrefix("listeners"), "http://0.0.0.0:8090");
        this.withEnv(this.mdsPrefix("advertised.listeners"), String.format("http://%s:8090", brokerNetworkAlias));
        this.withEnv(this.mdsPrefix("token.auth.enable"), "true");
        this.withEnv(this.mdsPrefix("token.max.lifetime.ms"), "7200000");
        this.withEnv(this.mdsPrefix("token.signature.algorithm"), "RS256");
        this.withEnv(this.mdsPrefix("token.key.path"), "/tmp/conf/keypair.pem");
        this.withEnv(this.mdsPrefix("public.key.path"), "/tmp/conf/public.pem");
        this.withEnv(CPTestContainerFactory.pToEKafka("confluent.authorizer.access.rule.providers"), "CONFLUENT,ZK_ACL");
        this.withEnv("CONFLUENT_METRICS_REPORTER_SECURITY_PROTOCOL", "SASL_PLAINTEXT");
        this.withEnv("CONFLUENT_METRICS_REPORTER_SASL_MECHANISM", "PLAIN");
        this.withEnv("CONFLUENT_METRICS_REPORTER_SASL_JAAS_CONFIG", SecurityConfigs.plainJaas("admin", "admin-secret"));
        this.withEnv("KAFKA_LDAP_JAVA_NAMING_FACTORY_INITIAL", "com.sun.jndi.ldap.LdapCtxFactory");
        this.withEnv("KAFKA_LDAP_COM_SUN_JNDI_LDAP_READ_TIMEOUT", "3000");
        this.withEnv("KAFKA_LDAP_JAVA_NAMING_PROVIDER_URL", "ldap://ldap:389");
        this.withEnv("KAFKA_LDAP_JAVA_NAMING_SECURITY_PRINCIPAL", "cn=admin,dc=confluent,dc=io");
        this.withEnv("KAFKA_LDAP_JAVA_NAMING_SECURITY_CREDENTIALS", "admin");
        this.withEnv("KAFKA_LDAP_JAVA_NAMING_SECURITY_AUTHENTICATION", "simple");
        this.withEnv("KAFKA_LDAP_USER_SEARCH_BASE", "ou=users,dc=confluent,dc=io");
        this.withEnv("KAFKA_LDAP_GROUP_SEARCH_BASE", "ou=groups,dc=confluent,dc=io");
        this.withEnv("KAFKA_LDAP_USER_NAME_ATTRIBUTE", "uid");
        this.withEnv("KAFKA_LDAP_USER_OBJECT_CLASS", "inetOrgPerson");
        this.withEnv("KAFKA_LDAP_USER_MEMBEROF_ATTRIBUTE", "ou");
        this.withEnv("KAFKA_LDAP_GROUP_MEMBER_ATTRIBUTE", "memberUid");
        this.withEnv("KAFKA_LDAP_GROUP_NAME_ATTRIBUTE", "cn");
        this.withEnv("KAFKA_LDAP_GROUP_OBJECT_CLASS", "posixGroup");
        this.withEnv("KAFKA_LDAP_GROUP_MEMBER_ATTRIBUTE_PATTERN", "cn=(.*),ou=users,dc=confluent,dc=io");
        return this;
    }

    String mdsPrefix(String property) {
        return CPTestContainerFactory.pToEKafka("confluent.metadata.server." + property);
    }

    public String licenseTopic() {
        return "_confluent-license";
    }
}

