/*
 * Decompiled with CFR 0.152.
 */
package io.techery.properratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.techery.properratingbar.R;
import io.techery.properratingbar.RatingListener;

public class ProperRatingBar
extends LinearLayout {
    private static final int DF_TOTAL_TICKS = 5;
    private static final int DF_DEFAULT_TICKS = 3;
    private static final boolean DF_CLICKABLE = false;
    private static final int DF_SYMBOLIC_TICK_RES = R.string.prb_default_symbolic_string;
    private static final int DF_SYMBOLIC_TEXT_SIZE_RES = R.dimen.prb_symbolic_tick_default_text_size;
    private static final int DF_SYMBOLIC_TEXT_STYLE = 0;
    private static final int DF_SYMBOLIC_TEXT_NORMAL_COLOR = -16777216;
    private static final int DF_SYMBOLIC_TEXT_SELECTED_COLOR = -7829368;
    private static final int DF_TICK_SPACING_RES = R.dimen.prb_drawable_tick_default_spacing;
    private int totalTicks;
    private int lastSelectedTickIndex;
    private boolean isClickable;
    private String symbolicTick;
    private int customTextSize;
    private int customTextStyle;
    private int customTextNormalColor;
    private int customTextSelectedColor;
    private Drawable tickNormalDrawable;
    private Drawable tickSelectedDrawable;
    private int tickSpacing;
    private boolean useSymbolicTick = false;
    private int rating;
    private RatingListener listener = null;
    private View.OnClickListener mTickClickedListener = new View.OnClickListener(){

        public void onClick(View v) {
            ProperRatingBar.this.lastSelectedTickIndex = (Integer)v.getTag(R.id.prb_child_tag_id);
            ProperRatingBar.this.rating = ProperRatingBar.this.lastSelectedTickIndex + 1;
            ProperRatingBar.this.redrawChildren();
            if (ProperRatingBar.this.listener != null) {
                ProperRatingBar.this.listener.onRatePicked(ProperRatingBar.this);
            }
        }
    };

    public ProperRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProperRatingBar);
        this.totalTicks = a.getInt(R.styleable.ProperRatingBar_prb_totalTicks, 5);
        this.rating = a.getInt(R.styleable.ProperRatingBar_prb_defaultRating, 3);
        this.isClickable = a.getBoolean(R.styleable.ProperRatingBar_prb_clickable, false);
        this.symbolicTick = a.getString(R.styleable.ProperRatingBar_prb_symbolicTick);
        if (this.symbolicTick == null) {
            this.symbolicTick = context.getString(DF_SYMBOLIC_TICK_RES);
        }
        this.customTextSize = a.getDimensionPixelSize(R.styleable.ProperRatingBar_android_textSize, context.getResources().getDimensionPixelOffset(DF_SYMBOLIC_TEXT_SIZE_RES));
        this.customTextStyle = a.getInt(R.styleable.ProperRatingBar_android_textStyle, 0);
        this.customTextNormalColor = a.getColor(R.styleable.ProperRatingBar_prb_symbolicTickNormalColor, -16777216);
        this.customTextSelectedColor = a.getColor(R.styleable.ProperRatingBar_prb_symbolicTickSelectedColor, -7829368);
        this.tickNormalDrawable = a.getDrawable(R.styleable.ProperRatingBar_prb_tickNormalDrawable);
        this.tickSelectedDrawable = a.getDrawable(R.styleable.ProperRatingBar_prb_tickSelectedDrawable);
        this.tickSpacing = a.getDimensionPixelOffset(R.styleable.ProperRatingBar_prb_tickSpacing, context.getResources().getDimensionPixelOffset(DF_TICK_SPACING_RES));
        this.afterInit();
        a.recycle();
    }

    private void afterInit() {
        if (this.rating > this.totalTicks) {
            this.rating = this.totalTicks;
        }
        this.lastSelectedTickIndex = this.rating - 1;
        if (this.tickNormalDrawable == null || this.tickSelectedDrawable == null) {
            this.useSymbolicTick = true;
        }
        this.addChildren(this.getContext());
    }

    private void addChildren(Context context) {
        this.removeAllViews();
        for (int i = 0; i < this.totalTicks; ++i) {
            this.addChild(context, i);
        }
        this.redrawChildren();
    }

    private void addChild(Context context, int position) {
        if (this.useSymbolicTick) {
            this.addSymbolicChild(context, position);
        } else {
            this.addDrawableChild(context, position);
        }
    }

    private void addSymbolicChild(Context context, int position) {
        TextView tv = new TextView(context);
        tv.setText((CharSequence)this.symbolicTick);
        tv.setTextSize(0, (float)this.customTextSize);
        if (this.customTextStyle != 0) {
            tv.setTypeface(Typeface.DEFAULT, this.customTextStyle);
        }
        if (this.isClickable) {
            tv.setTag(R.id.prb_child_tag_id, (Object)position);
            tv.setOnClickListener(this.mTickClickedListener);
        }
        this.addView((View)tv);
    }

    private void addDrawableChild(Context context, int position) {
        ImageView iv = new ImageView(context);
        iv.setPadding(this.tickSpacing, this.tickSpacing, this.tickSpacing, this.tickSpacing);
        if (this.isClickable) {
            iv.setTag(R.id.prb_child_tag_id, (Object)position);
            iv.setOnClickListener(this.mTickClickedListener);
        }
        this.addView((View)iv);
    }

    private void redrawChildren() {
        for (int i = 0; i < this.totalTicks; ++i) {
            if (this.useSymbolicTick) {
                this.redrawChildSelection((TextView)this.getChildAt(i), i <= this.lastSelectedTickIndex);
                continue;
            }
            this.redrawChildSelection((ImageView)this.getChildAt(i), i <= this.lastSelectedTickIndex);
        }
    }

    private void redrawChildSelection(ImageView child, boolean isSelected) {
        if (isSelected) {
            child.setImageDrawable(this.tickSelectedDrawable);
        } else {
            child.setImageDrawable(this.tickNormalDrawable);
        }
    }

    private void redrawChildSelection(TextView child, boolean isSelected) {
        if (isSelected) {
            child.setTextColor(this.customTextSelectedColor);
        } else {
            child.setTextColor(this.customTextNormalColor);
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.rating = this.rating;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setRating(savedState.rating);
    }

    @Nullable
    public RatingListener getListener() {
        return this.listener;
    }

    public void setListener(RatingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null!");
        }
        this.listener = listener;
        this.isClickable = true;
    }

    public void removeRatingListener() {
        this.listener = null;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        if (rating > this.totalTicks) {
            rating = this.totalTicks;
        }
        this.rating = rating;
        this.lastSelectedTickIndex = rating - 1;
        this.redrawChildren();
    }

    public void setSymbolicTick(String tick) {
        this.symbolicTick = tick;
        this.afterInit();
    }

    public String getSymbolicTick() {
        return this.symbolicTick;
    }

    static class SavedState
    extends View.BaseSavedState {
        int rating;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.rating = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.rating);
        }
    }
}

