/*
 * Decompiled with CFR 0.152.
 */
package com.tapadoo.alerter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.tapadoo.alerter.OnHideAlertListener;
import com.tapadoo.alerter.OnShowAlertListener;
import com.tapadoo.android.R;

public class Alert
extends FrameLayout
implements View.OnClickListener,
Animation.AnimationListener {
    private static final int CLEAN_UP_DELAY_MILLIS = 100;
    private static final long DISPLAY_TIME_IN_SECONDS = 3000L;
    private FrameLayout flBackground;
    private TextView tvTitle;
    private TextView tvText;
    private ImageView ivIcon;
    private Animation slideInAnimation;
    private Animation slideOutAnimation;
    private OnShowAlertListener onShowListener;
    private OnHideAlertListener onHideListener;
    private long duration = 3000L;
    private boolean enableIconPulse = true;
    private boolean marginSet;

    public Alert(@NonNull Context context) {
        super(context, null, R.attr.alertStyle);
        this.initView();
    }

    public Alert(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, R.attr.alertStyle);
        this.initView();
    }

    public Alert(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        Alert.inflate((Context)this.getContext(), (int)R.layout.alerter_alert_view, (ViewGroup)this);
        this.setHapticFeedbackEnabled(true);
        this.flBackground = (FrameLayout)this.findViewById(R.id.flAlertBackground);
        this.ivIcon = (ImageView)this.findViewById(R.id.ivIcon);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.tvText = (TextView)this.findViewById(R.id.tvText);
        this.flBackground.setOnClickListener((View.OnClickListener)this);
        this.slideInAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.alerter_slide_in_from_top);
        this.slideOutAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.alerter_slide_out_to_top);
        this.slideInAnimation.setAnimationListener((Animation.AnimationListener)this);
        this.setAnimation(this.slideInAnimation);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.marginSet) {
            this.marginSet = true;
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            params.topMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.alerter_alert_negative_margin_top);
            this.requestLayout();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.slideInAnimation.setAnimationListener(null);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.performClick();
        return super.onTouchEvent(event);
    }

    public void onClick(View v) {
        this.hide();
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.flBackground.setOnClickListener(listener);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(visibility);
        }
    }

    public void onAnimationStart(Animation animation) {
        if (!this.isInEditMode()) {
            this.performHapticFeedback(1);
            this.setVisibility(0);
        }
    }

    public void onAnimationEnd(Animation animation) {
        if (this.enableIconPulse) {
            try {
                this.ivIcon.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.alerter_pulse));
            }
            catch (Exception ex) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)Log.getStackTraceString((Throwable)ex));
            }
        }
        if (this.onShowListener != null) {
            this.onShowListener.onShow();
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                Alert.this.hide();
            }
        }, this.duration);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void hide() {
        try {
            this.slideOutAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    Alert.this.flBackground.setOnClickListener(null);
                    Alert.this.flBackground.setClickable(false);
                }

                public void onAnimationEnd(Animation animation) {
                    Alert.this.removeFromParent();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.startAnimation(this.slideOutAnimation);
        }
        catch (Exception ex) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)Log.getStackTraceString((Throwable)ex));
        }
    }

    private void removeFromParent() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        if (Alert.this.getParent() == null) {
                            Log.e((String)this.getClass().getSimpleName(), (String)"getParent() returning Null");
                            break block6;
                        }
                        try {
                            ((ViewGroup)Alert.this.getParent()).removeView((View)Alert.this);
                            if (Alert.this.onHideListener != null) {
                                Alert.this.onHideListener.onHide();
                            }
                        }
                        catch (Exception ex) {
                            Log.e((String)this.getClass().getSimpleName(), (String)"Cannot remove from parent layout");
                        }
                    }
                    catch (Exception ex) {
                        Log.e((String)this.getClass().getSimpleName(), (String)Log.getStackTraceString((Throwable)ex));
                    }
                }
            }
        }, 100L);
    }

    public void setAlertBackgroundColor(@ColorInt int color) {
        this.flBackground.setBackgroundColor(color);
    }

    public void setTitle(@StringRes int titleId) {
        this.setTitle(this.getContext().getString(titleId));
    }

    public void setText(@StringRes int textId) {
        this.setText(this.getContext().getString(textId));
    }

    public FrameLayout getAlertBackground() {
        return this.flBackground;
    }

    public TextView getTitle() {
        return this.tvTitle;
    }

    public void setTitle(@NonNull String title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.tvTitle.setVisibility(0);
            this.tvTitle.setText((CharSequence)title);
        }
    }

    public TextView getText() {
        return this.tvText;
    }

    public void setText(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.tvText.setVisibility(0);
            this.tvText.setText((CharSequence)text);
        }
    }

    public ImageView getIcon() {
        return this.ivIcon;
    }

    public void setIcon(@DrawableRes int iconId) {
        Drawable iconDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)iconId);
        this.ivIcon.setImageDrawable(iconDrawable);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void pulseIcon(boolean shouldPulse) {
        this.enableIconPulse = shouldPulse;
    }

    public void setOnShowListener(@NonNull OnShowAlertListener listener) {
        this.onShowListener = listener;
    }

    public void setOnHideListener(@NonNull OnHideAlertListener listener) {
        this.onHideListener = listener;
    }
}

