/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme.internal;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FlingAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.takusemba.cropme.internal.MoveAnimator;
import com.takusemba.cropme.internal.VerticalAnimatorImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/takusemba/cropme/internal/VerticalAnimatorImpl;", "Lcom/takusemba/cropme/internal/MoveAnimator;", "targetView", "Landroid/view/View;", "topBound", "", "bottomBound", "maxScale", "(Landroid/view/View;FFF)V", "spring", "Landroidx/dynamicanimation/animation/SpringAnimation;", "fling", "Landroidx/dynamicanimation/animation/FlingAnimation;", "animator", "Landroid/animation/ObjectAnimator;", "(Landroid/view/View;FFFLandroidx/dynamicanimation/animation/SpringAnimation;Landroidx/dynamicanimation/animation/FlingAnimation;Landroid/animation/ObjectAnimator;)V", "updateListener", "Landroidx/dynamicanimation/animation/DynamicAnimation$OnAnimationUpdateListener;", "adjust", "", "adjustToBounds", "rect", "Landroid/graphics/Rect;", "velocity", "cancel", "expectRect", "move", "delta", "outOfBounds", "", "Companion", "cropme_release"})
public final class VerticalAnimatorImpl
implements MoveAnimator {
    private final DynamicAnimation.OnAnimationUpdateListener updateListener;
    private final View targetView;
    private final float topBound;
    private final float bottomBound;
    private final float maxScale;
    private final SpringAnimation spring;
    private final FlingAnimation fling;
    private final ObjectAnimator animator;
    private static final ObjectAnimator ANIMATOR;
    private static final Companion.HORIZONTAL_PROPERTY.1 HORIZONTAL_PROPERTY;
    private static final SpringForce SPRING_FORCE;
    @NotNull
    public static final Companion Companion;

    @Override
    public void move(float delta) {
        this.cancel();
        this.animator.setFloatValues(new float[]{this.targetView.getTranslationY() + delta});
        this.animator.start();
    }

    @Override
    public void adjust() {
        Rect expectedRect = this.expectRect();
        if (this.outOfBounds(expectedRect)) {
            VerticalAnimatorImpl.adjustToBounds$default(this, expectedRect, 0.0f, 2, null);
        }
    }

    @Override
    public void fling(float velocity) {
        this.cancel();
        this.fling.addUpdateListener(this.updateListener);
        this.fling.setStartVelocity(velocity).start();
    }

    private final Rect expectRect() {
        Rect rect;
        Rect targetRect = new Rect();
        this.targetView.getHitRect(targetRect);
        if (this.maxScale < this.targetView.getScaleY()) {
            int heightDiff = (int)(((float)targetRect.height() - (float)targetRect.height() * (this.maxScale / this.targetView.getScaleY())) / (float)2);
            int widthDiff = (int)(((float)targetRect.width() - (float)targetRect.width() * (this.maxScale / this.targetView.getScaleY())) / (float)2);
            rect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
        } else if (this.targetView.getScaleY() < 1.0f) {
            int heightDiff = (this.targetView.getHeight() - targetRect.height()) / 2;
            int widthDiff = (this.targetView.getWidth() - targetRect.width()) / 2;
            rect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
        } else {
            rect = targetRect;
        }
        return rect;
    }

    private final boolean outOfBounds(Rect rect) {
        return this.topBound < (float)rect.top || (float)rect.bottom < this.bottomBound;
    }

    private final void adjustToBounds(Rect rect, float velocity) {
        float scale = this.maxScale < this.targetView.getScaleX() ? this.maxScale : (this.targetView.getScaleX() < 1.0f ? 1.0f : this.targetView.getScaleX());
        float diff = ((float)this.targetView.getHeight() * scale - (float)this.targetView.getHeight()) / (float)2;
        if (this.topBound < (float)rect.top) {
            this.cancel();
            float finalPosition = this.topBound + diff;
            ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(finalPosition);
        } else if ((float)rect.bottom < this.bottomBound) {
            this.cancel();
            float finalPosition = this.bottomBound - (float)this.targetView.getHeight() - diff;
            ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(finalPosition);
        }
    }

    static /* synthetic */ void adjustToBounds$default(VerticalAnimatorImpl verticalAnimatorImpl, Rect rect, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        verticalAnimatorImpl.adjustToBounds(rect, f);
    }

    private final void cancel() {
        this.animator.cancel();
        this.spring.cancel();
        this.fling.cancel();
        this.fling.removeUpdateListener(this.updateListener);
    }

    @VisibleForTesting
    public VerticalAnimatorImpl(@NotNull View targetView, float topBound, float bottomBound, float maxScale, @NotNull SpringAnimation spring, @NotNull FlingAnimation fling, @NotNull ObjectAnimator animator) {
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        Intrinsics.checkNotNullParameter((Object)spring, (String)"spring");
        Intrinsics.checkNotNullParameter((Object)fling, (String)"fling");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        this.targetView = targetView;
        this.topBound = topBound;
        this.bottomBound = bottomBound;
        this.maxScale = maxScale;
        this.spring = spring;
        this.fling = fling;
        this.animator = animator;
        this.updateListener = new DynamicAnimation.OnAnimationUpdateListener(this){
            final /* synthetic */ VerticalAnimatorImpl this$0;

            public final void onAnimationUpdate(DynamicAnimation<DynamicAnimation<?>> $noName_0, float $noName_1, float velocity) {
                Rect expectedRect = VerticalAnimatorImpl.access$expectRect(this.this$0);
                if (VerticalAnimatorImpl.access$outOfBounds(this.this$0, expectedRect)) {
                    VerticalAnimatorImpl.access$adjustToBounds(this.this$0, expectedRect, velocity);
                }
            }
            {
                this.this$0 = verticalAnimatorImpl;
            }
        };
        this.animator.setTarget((Object)this.targetView);
    }

    public VerticalAnimatorImpl(@NotNull View targetView, float topBound, float bottomBound, float maxScale) {
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        SpringAnimation springAnimation = new SpringAnimation((Object)targetView, (FloatPropertyCompat)HORIZONTAL_PROPERTY).setSpring(SPRING_FORCE);
        Intrinsics.checkNotNullExpressionValue((Object)springAnimation, (String)"SpringAnimation(targetVi\u2026).setSpring(SPRING_FORCE)");
        FlingAnimation flingAnimation = new FlingAnimation((Object)targetView, (FloatPropertyCompat)DynamicAnimation.Y).setFriction(3.0f);
        Intrinsics.checkNotNullExpressionValue((Object)flingAnimation, (String)"FlingAnimation(targetVie\u2026.Y).setFriction(FRICTION)");
        this(targetView, topBound, bottomBound, maxScale, springAnimation, flingAnimation, ANIMATOR);
    }

    static {
        Companion = new Companion(null);
        ObjectAnimator objectAnimator = new ObjectAnimator();
        boolean bl = false;
        boolean bl2 = false;
        ObjectAnimator $this$apply = objectAnimator;
        boolean bl3 = false;
        $this$apply.setProperty(View.TRANSLATION_Y);
        $this$apply.setInterpolator((TimeInterpolator)null);
        $this$apply.setDuration(0L);
        ANIMATOR = objectAnimator;
        HORIZONTAL_PROPERTY = new FloatPropertyCompat<View>("Y"){

            public float getValue(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                return view.getY();
            }

            public void setValue(@NotNull View view, float value) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                view.setY(value);
            }
        };
        SPRING_FORCE = new SpringForce().setStiffness(50.0f).setDampingRatio(1.0f);
    }

    public static final /* synthetic */ Rect access$expectRect(VerticalAnimatorImpl $this) {
        return $this.expectRect();
    }

    public static final /* synthetic */ boolean access$outOfBounds(VerticalAnimatorImpl $this, Rect rect) {
        return $this.outOfBounds(rect);
    }

    public static final /* synthetic */ void access$adjustToBounds(VerticalAnimatorImpl $this, Rect rect, float velocity) {
        $this.adjustToBounds(rect, velocity);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/takusemba/cropme/internal/VerticalAnimatorImpl$Companion;", "", "()V", "ANIMATOR", "Landroid/animation/ObjectAnimator;", "HORIZONTAL_PROPERTY", "com/takusemba/cropme/internal/VerticalAnimatorImpl$Companion$HORIZONTAL_PROPERTY$1", "Lcom/takusemba/cropme/internal/VerticalAnimatorImpl$Companion$HORIZONTAL_PROPERTY$1;", "SPRING_FORCE", "Landroidx/dynamicanimation/animation/SpringForce;", "kotlin.jvm.PlatformType", "cropme_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

