/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import com.takusemba.cropme.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 !2\u00020\u0001:\u0001!B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH&J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH&J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/takusemba/cropme/CropOverlay;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "cropOverlayAttrs", "(Landroid/content/Context;Landroid/util/AttributeSet;ILandroid/util/AttributeSet;)V", "backgroundPaint", "Landroid/graphics/Paint;", "borderPaint", "cropPaint", "<set-?>", "Landroid/graphics/RectF;", "frame", "getFrame", "()Landroid/graphics/RectF;", "drawBackground", "", "canvas", "Landroid/graphics/Canvas;", "paint", "drawBorder", "drawCrop", "onDraw", "setFrame", "setLayerType", "layerType", "setWillNotDraw", "willNotDraw", "", "Companion", "cropme_release"})
public abstract class CropOverlay
extends FrameLayout {
    private final Paint backgroundPaint;
    private final Paint cropPaint;
    private final Paint borderPaint;
    @Nullable
    private RectF frame;
    private static final int BORDER_WIDTH = 5;
    private static final int DEFAULT_BASE = 1;
    private static final int DEFAULT_PBASE = 1;
    private static final float DEFAULT_BACKGROUND_ALPHA = 0.8f;
    private static final float COLOR_DENSITY = 255.0f;
    private static final boolean DEFAULT_WITH_BORDER = true;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final RectF getFrame() {
        return this.frame;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawBackground(canvas, this.backgroundPaint);
        this.drawCrop(canvas, this.cropPaint);
        if (this.borderPaint != null) {
            this.drawBorder(canvas, this.borderPaint);
        }
    }

    public void drawBackground(@NotNull Canvas canvas, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.backgroundPaint);
    }

    public abstract void drawCrop(@NotNull Canvas var1, @NotNull Paint var2);

    public abstract void drawBorder(@NotNull Canvas var1, @NotNull Paint var2);

    public final void setFrame(@NotNull RectF frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
    }

    public final void setWillNotDraw(boolean willNotDraw) {
        super.setWillNotDraw(willNotDraw);
    }

    public final void setLayerType(int layerType, @Nullable Paint paint) {
        super.setLayerType(layerType, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public CropOverlay(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet cropOverlayAttrs) {
        Paint paint;
        Paint $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        float backgroundAlpha = 0.0f;
        boolean withBorder = false;
        if (cropOverlayAttrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(cropOverlayAttrs, R.styleable.CropOverlay, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026leable.CropOverlay, 0, 0)");
            TypedArray a = typedArray;
            try {
                backgroundAlpha = a.getFraction(R.styleable.CropLayout_cropme_background_alpha, 1, 1, 0.8f);
                withBorder = a.getBoolean(R.styleable.CropOverlay_cropme_with_border, true);
            }
            finally {
                a.recycle();
            }
        } else {
            backgroundAlpha = 0.8f;
            withBorder = true;
        }
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
        Paint paint2 = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint3 = paint2;
        CropOverlay cropOverlay = this;
        boolean bl3 = false;
        $this$apply.setColor(ContextCompat.getColor((Context)context, (int)17170444));
        $this$apply.setAlpha((int)(backgroundAlpha * 255.0f));
        Unit unit = Unit.INSTANCE;
        cropOverlay.backgroundPaint = paint2;
        paint2 = new Paint();
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        cropOverlay = this;
        boolean bl4 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        unit = Unit.INSTANCE;
        cropOverlay.cropPaint = paint2;
        CropOverlay cropOverlay2 = this;
        if (withBorder) {
            paint2 = new Paint();
            bl = false;
            bl2 = false;
            $this$apply = paint2;
            cropOverlay = cropOverlay2;
            boolean bl5 = false;
            $this$apply.setStrokeWidth((float)5);
            $this$apply.setStyle(Paint.Style.STROKE);
            $this$apply.setColor(ContextCompat.getColor((Context)context, (int)R.color.light_white));
            unit = Unit.INSTANCE;
            cropOverlay2 = cropOverlay;
            paint = paint2;
        } else {
            paint = null;
        }
        cropOverlay2.borderPaint = paint;
    }

    public /* synthetic */ CropOverlay(Context context, AttributeSet attributeSet, int n, AttributeSet attributeSet2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            attributeSet2 = attributeSet;
        }
        this(context, attributeSet, n, attributeSet2);
    }

    @JvmOverloads
    public CropOverlay(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public CropOverlay(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public CropOverlay(@NotNull Context context) {
        this(context, null, 0, null, 14, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/takusemba/cropme/CropOverlay$Companion;", "", "()V", "BORDER_WIDTH", "", "COLOR_DENSITY", "", "DEFAULT_BACKGROUND_ALPHA", "DEFAULT_BASE", "DEFAULT_PBASE", "DEFAULT_WITH_BORDER", "", "cropme_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

