/*
 * Decompiled with CFR 0.152.
 */
package com.proximities.sdk.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.proximities.sdk.R;
import com.proximities.sdk.fragment.BaseFavoritesFragment;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.k.a;
import java.util.ArrayList;
import java.util.List;

public class DefaultFavoritesFragment
extends BaseFavoritesFragment {
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recycler;
    private TextView reconnection;
    private LinearLayout mLayoutNoFavorites;
    private List<Campaign> favorites = new ArrayList<Campaign>();
    private a adapter;

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.prxsc_default_fav_fragment, viewGroup, false);
        DefaultFavoritesFragment defaultFavoritesFragment = this;
        this.recycler = (RecyclerView)layoutInflater.findViewById(R.id.recycler_fav);
        this.reconnection = (TextView)layoutInflater.findViewById(R.id.reconnection);
        this.refreshLayout = (SwipeRefreshLayout)layoutInflater.findViewById(R.id.swipe_container);
        defaultFavoritesFragment.mLayoutNoFavorites = (LinearLayout)layoutInflater.findViewById(R.id.layout_no_favorites);
        defaultFavoritesFragment.refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                DefaultFavoritesFragment.this.refreshFavorites();
            }
        });
        defaultFavoritesFragment.reconnection.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DefaultFavoritesFragment.this.refreshFavorites();
            }
        });
        defaultFavoritesFragment.reconnection.setVisibility(8);
        defaultFavoritesFragment.recycler.setVisibility(0);
        defaultFavoritesFragment.adapter = new a((Context)this.getActivity(), this.favorites, this);
        defaultFavoritesFragment.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        return layoutInflater;
    }

    public void onResume() {
        DefaultFavoritesFragment defaultFavoritesFragment = this;
        super.onResume();
        defaultFavoritesFragment.refreshLayout.setRefreshing(true);
        defaultFavoritesFragment.refreshFavorites();
    }

    @Override
    public void onGetFavorites(List<Campaign> list) {
        DefaultFavoritesFragment defaultFavoritesFragment = this;
        super.onGetFavorites(list);
        defaultFavoritesFragment.refreshLayout.setRefreshing(true);
        defaultFavoritesFragment.reconnection.setVisibility(8);
        defaultFavoritesFragment.recycler.setVisibility(0);
        defaultFavoritesFragment.favorites.clear();
        if (list != null && list.size() > 0) {
            DefaultFavoritesFragment defaultFavoritesFragment2 = this;
            defaultFavoritesFragment2.mLayoutNoFavorites.setVisibility(8);
            defaultFavoritesFragment2.favorites.addAll(list);
        } else {
            this.mLayoutNoFavorites.setVisibility(0);
        }
        DefaultFavoritesFragment defaultFavoritesFragment3 = this;
        defaultFavoritesFragment3.adapter.notifyDataSetChanged();
        defaultFavoritesFragment3.refreshLayout.setRefreshing(false);
    }

    @Override
    public void onGetFavoritesError() {
        DefaultFavoritesFragment defaultFavoritesFragment = this;
        super.onGetFavoritesError();
        defaultFavoritesFragment.refreshLayout.setRefreshing(false);
        defaultFavoritesFragment.reconnection.setVisibility(0);
        defaultFavoritesFragment.recycler.setVisibility(8);
    }

    public void onStart() {
        DefaultFavoritesFragment defaultFavoritesFragment = this;
        super.onStart();
        defaultFavoritesFragment.recycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 2));
    }

    public void onStop() {
        super.onStop();
    }
}

