package com.proximities.sdk.activities;

import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.proximities.sdk.BaseCampaignActivity;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.Utils;

/**
 * Created by william on 05/12/16.
 */

public class SimpleNotificationActivity extends BaseCampaignActivity {

    private Campaign campaign;
    private Button btnClose;
    private Button btnPositive;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        campaign = getCampaigns().get(0);
        if(ProximitiesConfig.getInstance().isDialogBeforeDeepLinkEnabled() && (!isCampaignOpenByPush() || isOpeningFromMulti())){
            setContentView(R.layout.prxsc_simple_notification_activity);
            getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            this.setFinishOnTouchOutside(false);
            initSimpleNotificationDesign();
            handleCloseButton();
            handlePositiveButton();
        } else {
            handleIdentifier();
        }
    }

    private void initSimpleNotificationDesign(){
        TextView title = (TextView) findViewById(R.id.title);
        title.setTextColor(ContextCompat.getColor(this, R.color.prxsc_simple_push_title));
        title.setBackgroundColor(ContextCompat.getColor(this, R.color.prxsc_simple_push_dialog));
        TextView message = (TextView) findViewById(R.id.message);
        title.setText(campaign.getPoi().getName());
        message.setText(campaign.getTitle());

        btnPositive = (Button) findViewById(R.id.positive_button);
        btnPositive.setTextColor(ContextCompat.getColor(this, R.color.prxsc_simple_push_dialog));
        btnClose = (Button) findViewById(R.id.close_button);
        btnClose.setTextColor(ContextCompat.getColor(this, R.color.prxsc_simple_push_dialog));
    }

    private void handleCloseButton(){
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(isOpeningFromMulti()){
                    finish();
                } else {
                    Utils.endCampaignDisplay(SimpleNotificationActivity.this, false);
                }
            }
        });
    }

    private void handlePositiveButton(){
        btnPositive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
             handleIdentifier();
            }
        });
    }

    private void handleIdentifier(){
        if(ProximitiesConfig.getOnCatchIdentifierListener() != null) {
            sendCustomLog(ProximitiesConstants.LOG_ACTION_DONE);
            ProximitiesConfig.getOnCatchIdentifierListener().onCatchIdentifier(campaign.getIdentifier());
        }
        finish();
    }
}

