/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.commons;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.stfalcon.chatkit.R;

public abstract class Style {
    protected Context context;
    protected Resources resources;
    protected AttributeSet attrs;

    protected Style(Context context, AttributeSet attrs) {
        this.context = context;
        this.resources = context.getResources();
        this.attrs = attrs;
    }

    protected final int getSystemAccentColor() {
        return this.getSystemColor(R.attr.colorAccent);
    }

    protected final int getSystemPrimaryColor() {
        return this.getSystemColor(R.attr.colorPrimary);
    }

    protected final int getSystemPrimaryDarkColor() {
        return this.getSystemColor(R.attr.colorPrimaryDark);
    }

    protected final int getSystemPrimaryTextColor() {
        return this.getSystemColor(16842806);
    }

    protected final int getSystemHintColor() {
        return this.getSystemColor(16842906);
    }

    protected final int getSystemColor(@AttrRes int attr2) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = this.context.obtainStyledAttributes(typedValue.data, new int[]{attr2});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    protected final int getDimension(@DimenRes int dimen2) {
        return this.resources.getDimensionPixelSize(dimen2);
    }

    protected final int getColor(@ColorRes int color2) {
        return ContextCompat.getColor((Context)this.context, (int)color2);
    }

    protected final Drawable getDrawable(@DrawableRes int drawable2) {
        return ContextCompat.getDrawable((Context)this.context, (int)drawable2);
    }

    protected final Drawable getVectorDrawable(@DrawableRes int drawable2) {
        return ContextCompat.getDrawable((Context)this.context, (int)drawable2);
    }
}

