/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.MonitorEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "id", "transaction", "value", "type", "severity"})
public class VariableMonitoring {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Identifies the monitor.\r\n")
    @NotNull
    private Integer id;
    @JsonProperty(value="transaction")
    @JsonPropertyDescription(value="Monitor only active when a transaction is ongoing on a component relevant to this transaction. \r\n")
    @NotNull
    private Boolean transaction;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Value for threshold or delta monitoring.\r\nFor Periodic or PeriodicClockAligned this is the interval in seconds.\r\n")
    @NotNull
    private Double value;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of this monitor, e.g. a threshold, delta or periodic monitor. \r\n")
    @NotNull
    private MonitorEnum type;
    @JsonProperty(value="severity")
    @JsonPropertyDescription(value="The severity that will be assigned to an event that is triggered by this monitor. The severity range is 0-9, with 0 as the highest and 9 as the lowest severity level.\r\n\r\nThe severity levels have the following meaning: +\r\n*0-Danger* +\r\nIndicates lives are potentially in danger. Urgent attention is needed and action should be taken immediately. +\r\n*1-Hardware Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to Hardware issues. Action is required. +\r\n*2-System Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to software or minor hardware issues. Action is required. +\r\n*3-Critical* +\r\nIndicates a critical error. Action is required. +\r\n*4-Error* +\r\nIndicates a non-urgent error. Action is required. +\r\n*5-Alert* +\r\nIndicates an alert event. Default severity for any type of monitoring event.  +\r\n*6-Warning* +\r\nIndicates a warning event. Action may be required. +\r\n*7-Notice* +\r\nIndicates an unusual event. No immediate action is required. +\r\n*8-Informational* +\r\nIndicates a regular operational event. May be used for reporting, measuring throughput, etc. No action is required. +\r\n*9-Debug* +\r\nIndicates information useful to developers for debugging, not useful during operations.\r\n")
    @NotNull
    private Integer severity;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public VariableMonitoring withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public VariableMonitoring withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="transaction")
    public Boolean getTransaction() {
        return this.transaction;
    }

    @JsonProperty(value="transaction")
    public void setTransaction(Boolean transaction) {
        this.transaction = transaction;
    }

    public VariableMonitoring withTransaction(Boolean transaction) {
        this.transaction = transaction;
        return this;
    }

    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Double value) {
        this.value = value;
    }

    public VariableMonitoring withValue(Double value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="type")
    public MonitorEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MonitorEnum type) {
        this.type = type;
    }

    public VariableMonitoring withType(MonitorEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="severity")
    public Integer getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public VariableMonitoring withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VariableMonitoring.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("transaction");
        sb.append('=');
        sb.append(this.transaction == null ? "<null>" : this.transaction);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(this.severity == null ? "<null>" : this.severity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.transaction == null ? 0 : this.transaction.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VariableMonitoring)) {
            return false;
        }
        VariableMonitoring rhs = (VariableMonitoring)other;
        return (this.severity == rhs.severity || this.severity != null && this.severity.equals(rhs.severity)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.transaction == rhs.transaction || this.transaction != null && this.transaction.equals(rhs.transaction));
    }
}

