/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "name", "instance"})
public class Variable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the variable. Name should be taken from the list of standardized variable names whenever possible. Case Insensitive. strongly advised to use Camel Case.\r\n")
    @Size(max=50)
    @NotNull
    private @Size(max=50) @NotNull String name;
    @JsonProperty(value="instance")
    @JsonPropertyDescription(value="Name of instance in case the variable exists as multiple instances. Case Insensitive. strongly advised to use Camel Case.\r\n")
    @Size(max=50)
    private @Size(max=50) String instance;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public Variable withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Variable withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    @JsonProperty(value="instance")
    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Variable withInstance(String instance) {
        this.instance = instance;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Variable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("instance");
        sb.append('=');
        sb.append(this.instance == null ? "<null>" : this.instance);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.instance == null ? 0 : this.instance.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable rhs = (Variable)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.instance == rhs.instance || this.instance != null && this.instance.equals(rhs.instance));
    }
}

