/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.LocationEnum;
import ocpp._2020._03.MeasurandEnum;
import ocpp._2020._03.PhaseEnum;
import ocpp._2020._03.ReadingContextEnum;
import ocpp._2020._03.SignedMeterValue;
import ocpp._2020._03.UnitOfMeasure;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "value", "context", "measurand", "phase", "location", "signedMeterValue", "unitOfMeasure"})
public class SampledValue {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Sampled_ Value. Value. Measure\r\nurn:x-oca:ocpp:uid:1:569260\r\nIndicates the measured value.\r\n\r\n")
    @NotNull
    private Double value;
    @JsonProperty(value="context")
    @JsonPropertyDescription(value="Sampled_ Value. Context. Reading_ Context_ Code\r\nurn:x-oca:ocpp:uid:1:569261\r\nType of detail value: start, end or sample. Default = \"Sample.Periodic\"\r\n")
    private ReadingContextEnum context = ReadingContextEnum.fromValue("Sample.Periodic");
    @JsonProperty(value="measurand")
    @JsonPropertyDescription(value="Sampled_ Value. Measurand. Measurand_ Code\r\nurn:x-oca:ocpp:uid:1:569263\r\nType of measurement. Default = \"Energy.Active.Import.Register\"\r\n")
    private MeasurandEnum measurand = MeasurandEnum.fromValue("Energy.Active.Import.Register");
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="Sampled_ Value. Phase. Phase_ Code\r\nurn:x-oca:ocpp:uid:1:569264\r\nIndicates how the measured value is to be interpreted. For instance between L1 and neutral (L1-N) Please note that not all values of phase are applicable to all Measurands. When phase is absent, the measured value is interpreted as an overall value.\r\n")
    private PhaseEnum phase;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="Sampled_ Value. Location. Location_ Code\r\nurn:x-oca:ocpp:uid:1:569265\r\nIndicates where the measured value has been sampled. Default =  \"Outlet\"\r\n\r\n")
    private LocationEnum location = LocationEnum.fromValue("Outlet");
    @JsonProperty(value="signedMeterValue")
    @JsonPropertyDescription(value="Represent a signed version of the meter value.\r\n")
    @Valid
    private SignedMeterValue signedMeterValue;
    @JsonProperty(value="unitOfMeasure")
    @JsonPropertyDescription(value="Represents a UnitOfMeasure with a multiplier\r\n")
    @Valid
    private UnitOfMeasure unitOfMeasure;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SampledValue withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Double value) {
        this.value = value;
    }

    public SampledValue withValue(Double value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="context")
    public ReadingContextEnum getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(ReadingContextEnum context) {
        this.context = context;
    }

    public SampledValue withContext(ReadingContextEnum context) {
        this.context = context;
        return this;
    }

    @JsonProperty(value="measurand")
    public MeasurandEnum getMeasurand() {
        return this.measurand;
    }

    @JsonProperty(value="measurand")
    public void setMeasurand(MeasurandEnum measurand) {
        this.measurand = measurand;
    }

    public SampledValue withMeasurand(MeasurandEnum measurand) {
        this.measurand = measurand;
        return this;
    }

    @JsonProperty(value="phase")
    public PhaseEnum getPhase() {
        return this.phase;
    }

    @JsonProperty(value="phase")
    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public SampledValue withPhase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @JsonProperty(value="location")
    public LocationEnum getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(LocationEnum location) {
        this.location = location;
    }

    public SampledValue withLocation(LocationEnum location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="signedMeterValue")
    public SignedMeterValue getSignedMeterValue() {
        return this.signedMeterValue;
    }

    @JsonProperty(value="signedMeterValue")
    public void setSignedMeterValue(SignedMeterValue signedMeterValue) {
        this.signedMeterValue = signedMeterValue;
    }

    public SampledValue withSignedMeterValue(SignedMeterValue signedMeterValue) {
        this.signedMeterValue = signedMeterValue;
        return this;
    }

    @JsonProperty(value="unitOfMeasure")
    public UnitOfMeasure getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @JsonProperty(value="unitOfMeasure")
    public void setUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public SampledValue withUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SampledValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("context");
        sb.append('=');
        sb.append(this.context == null ? "<null>" : this.context);
        sb.append(',');
        sb.append("measurand");
        sb.append('=');
        sb.append(this.measurand == null ? "<null>" : this.measurand);
        sb.append(',');
        sb.append("phase");
        sb.append('=');
        sb.append(this.phase == null ? "<null>" : this.phase);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("signedMeterValue");
        sb.append('=');
        sb.append(this.signedMeterValue == null ? "<null>" : this.signedMeterValue);
        sb.append(',');
        sb.append("unitOfMeasure");
        sb.append('=');
        sb.append(this.unitOfMeasure == null ? "<null>" : this.unitOfMeasure);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.phase == null ? 0 : this.phase.hashCode());
        result = result * 31 + (this.signedMeterValue == null ? 0 : this.signedMeterValue.hashCode());
        result = result * 31 + (this.unitOfMeasure == null ? 0 : this.unitOfMeasure.hashCode());
        result = result * 31 + (this.context == null ? 0 : this.context.hashCode());
        result = result * 31 + (this.measurand == null ? 0 : this.measurand.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SampledValue)) {
            return false;
        }
        SampledValue rhs = (SampledValue)other;
        return (this.phase == rhs.phase || this.phase != null && this.phase.equals((Object)rhs.phase)) && (this.signedMeterValue == rhs.signedMeterValue || this.signedMeterValue != null && this.signedMeterValue.equals(rhs.signedMeterValue)) && (this.unitOfMeasure == rhs.unitOfMeasure || this.unitOfMeasure != null && this.unitOfMeasure.equals(rhs.unitOfMeasure)) && (this.context == rhs.context || this.context != null && this.context.equals((Object)rhs.context)) && (this.measurand == rhs.measurand || this.measurand != null && this.measurand.equals((Object)rhs.measurand)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.location == rhs.location || this.location != null && this.location.equals((Object)rhs.location)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }
}

