/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.AuthorizationStatusEnum;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.IdToken;
import ocpp._2020._03.MessageContent;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "status", "cacheExpiryDateTime", "chargingPriority", "language1", "evseId", "groupIdToken", "language2", "personalMessage"})
public class IdTokenInfo {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="ID_ Token. Status. Authorization_ Status\r\nurn:x-oca:ocpp:uid:1:569372\r\nCurrent status of the ID Token.\r\n")
    @NotNull
    private AuthorizationStatusEnum status;
    @JsonProperty(value="cacheExpiryDateTime")
    @JsonPropertyDescription(value="ID_ Token. Expiry. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569373\r\nDate and Time after which the token must be considered invalid.\r\n")
    private DateTime cacheExpiryDateTime;
    @JsonProperty(value="chargingPriority")
    @JsonPropertyDescription(value="Priority from a business point of view. Default priority is 0, The range is from -9 to 9. Higher values indicate a higher priority. The chargingPriority in &lt;&lt;transactioneventresponse,TransactionEventResponse&gt;&gt; overrules this one. \r\n")
    private Integer chargingPriority;
    @JsonProperty(value="language1")
    @JsonPropertyDescription(value="ID_ Token. Language1. Language_ Code\r\nurn:x-oca:ocpp:uid:1:569374\r\nPreferred user interface language of identifier user. Contains a language code as defined in &lt;&lt;ref-RFC5646,[RFC5646]&gt;&gt;.\r\n\r\n")
    @Size(max=8)
    private @Size(max=8) String language1;
    @JsonProperty(value="evseId")
    @JsonPropertyDescription(value="Only used when the IdToken is only valid for one or more specific EVSEs, not for the entire Charging Station.\r\n\r\n")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<Integer> evseId = new ArrayList<Integer>();
    @JsonProperty(value="groupIdToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    @Valid
    private IdToken groupIdToken;
    @JsonProperty(value="language2")
    @JsonPropertyDescription(value="ID_ Token. Language2. Language_ Code\r\nurn:x-oca:ocpp:uid:1:569375\r\nSecond preferred user interface language of identifier user. Don\u2019t use when language1 is omitted, has to be different from language1. Contains a language code as defined in &lt;&lt;ref-RFC5646,[RFC5646]&gt;&gt;.\r\n")
    @Size(max=8)
    private @Size(max=8) String language2;
    @JsonProperty(value="personalMessage")
    @JsonPropertyDescription(value="Message_ Content\r\nurn:x-enexis:ecdm:uid:2:234490\r\nContains message details, for a message to be displayed on a Charging Station.\r\n\r\n")
    @Valid
    private MessageContent personalMessage;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public IdTokenInfo withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="status")
    public AuthorizationStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(AuthorizationStatusEnum status) {
        this.status = status;
    }

    public IdTokenInfo withStatus(AuthorizationStatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="cacheExpiryDateTime")
    public DateTime getCacheExpiryDateTime() {
        return this.cacheExpiryDateTime;
    }

    @JsonProperty(value="cacheExpiryDateTime")
    public void setCacheExpiryDateTime(DateTime cacheExpiryDateTime) {
        this.cacheExpiryDateTime = cacheExpiryDateTime;
    }

    public IdTokenInfo withCacheExpiryDateTime(DateTime cacheExpiryDateTime) {
        this.cacheExpiryDateTime = cacheExpiryDateTime;
        return this;
    }

    @JsonProperty(value="chargingPriority")
    public Integer getChargingPriority() {
        return this.chargingPriority;
    }

    @JsonProperty(value="chargingPriority")
    public void setChargingPriority(Integer chargingPriority) {
        this.chargingPriority = chargingPriority;
    }

    public IdTokenInfo withChargingPriority(Integer chargingPriority) {
        this.chargingPriority = chargingPriority;
        return this;
    }

    @JsonProperty(value="language1")
    public String getLanguage1() {
        return this.language1;
    }

    @JsonProperty(value="language1")
    public void setLanguage1(String language1) {
        this.language1 = language1;
    }

    public IdTokenInfo withLanguage1(String language1) {
        this.language1 = language1;
        return this;
    }

    @JsonProperty(value="evseId")
    public List<Integer> getEvseId() {
        return this.evseId;
    }

    @JsonProperty(value="evseId")
    public void setEvseId(List<Integer> evseId) {
        this.evseId = evseId;
    }

    public IdTokenInfo withEvseId(List<Integer> evseId) {
        this.evseId = evseId;
        return this;
    }

    @JsonProperty(value="groupIdToken")
    public IdToken getGroupIdToken() {
        return this.groupIdToken;
    }

    @JsonProperty(value="groupIdToken")
    public void setGroupIdToken(IdToken groupIdToken) {
        this.groupIdToken = groupIdToken;
    }

    public IdTokenInfo withGroupIdToken(IdToken groupIdToken) {
        this.groupIdToken = groupIdToken;
        return this;
    }

    @JsonProperty(value="language2")
    public String getLanguage2() {
        return this.language2;
    }

    @JsonProperty(value="language2")
    public void setLanguage2(String language2) {
        this.language2 = language2;
    }

    public IdTokenInfo withLanguage2(String language2) {
        this.language2 = language2;
        return this;
    }

    @JsonProperty(value="personalMessage")
    public MessageContent getPersonalMessage() {
        return this.personalMessage;
    }

    @JsonProperty(value="personalMessage")
    public void setPersonalMessage(MessageContent personalMessage) {
        this.personalMessage = personalMessage;
    }

    public IdTokenInfo withPersonalMessage(MessageContent personalMessage) {
        this.personalMessage = personalMessage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IdTokenInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("cacheExpiryDateTime");
        sb.append('=');
        sb.append((Object)(this.cacheExpiryDateTime == null ? "<null>" : this.cacheExpiryDateTime));
        sb.append(',');
        sb.append("chargingPriority");
        sb.append('=');
        sb.append(this.chargingPriority == null ? "<null>" : this.chargingPriority);
        sb.append(',');
        sb.append("language1");
        sb.append('=');
        sb.append(this.language1 == null ? "<null>" : this.language1);
        sb.append(',');
        sb.append("evseId");
        sb.append('=');
        sb.append(this.evseId == null ? "<null>" : this.evseId);
        sb.append(',');
        sb.append("groupIdToken");
        sb.append('=');
        sb.append(this.groupIdToken == null ? "<null>" : this.groupIdToken);
        sb.append(',');
        sb.append("language2");
        sb.append('=');
        sb.append(this.language2 == null ? "<null>" : this.language2);
        sb.append(',');
        sb.append("personalMessage");
        sb.append('=');
        sb.append(this.personalMessage == null ? "<null>" : this.personalMessage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.evseId == null ? 0 : this.evseId.hashCode());
        result = result * 31 + (this.language2 == null ? 0 : this.language2.hashCode());
        result = result * 31 + (this.language1 == null ? 0 : this.language1.hashCode());
        result = result * 31 + (this.cacheExpiryDateTime == null ? 0 : this.cacheExpiryDateTime.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.chargingPriority == null ? 0 : this.chargingPriority.hashCode());
        result = result * 31 + (this.personalMessage == null ? 0 : this.personalMessage.hashCode());
        result = result * 31 + (this.groupIdToken == null ? 0 : this.groupIdToken.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IdTokenInfo)) {
            return false;
        }
        IdTokenInfo rhs = (IdTokenInfo)other;
        return (this.evseId == rhs.evseId || this.evseId != null && this.evseId.equals(rhs.evseId)) && (this.language2 == rhs.language2 || this.language2 != null && this.language2.equals(rhs.language2)) && (this.language1 == rhs.language1 || this.language1 != null && this.language1.equals(rhs.language1)) && (this.cacheExpiryDateTime == rhs.cacheExpiryDateTime || this.cacheExpiryDateTime != null && this.cacheExpiryDateTime.equals((Object)rhs.cacheExpiryDateTime)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.chargingPriority == rhs.chargingPriority || this.chargingPriority != null && this.chargingPriority.equals(rhs.chargingPriority)) && (this.personalMessage == rhs.personalMessage || this.personalMessage != null && this.personalMessage.equals(rhs.personalMessage)) && (this.groupIdToken == rhs.groupIdToken || this.groupIdToken != null && this.groupIdToken.equals(rhs.groupIdToken)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

