/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import ocpp._2020._03.ChargingLimitSourceEnum;
import ocpp._2020._03.ChargingProfilePurposeEnum;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "chargingProfilePurpose", "stackLevel", "chargingProfileId", "chargingLimitSource"})
public class ChargingProfileCriterion {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="chargingProfilePurpose")
    @JsonPropertyDescription(value="Charging_ Profile. Charging_ Profile_ Purpose. Charging_ Profile_ Purpose_ Code\r\nurn:x-oca:ocpp:uid:1:569231\r\nDefines the purpose of the schedule transferred by this profile\r\n")
    private ChargingProfilePurposeEnum chargingProfilePurpose;
    @JsonProperty(value="stackLevel")
    @JsonPropertyDescription(value="Charging_ Profile. Stack_ Level. Counter\r\nurn:x-oca:ocpp:uid:1:569230\r\nValue determining level in hierarchy stack of profiles. Higher values have precedence over lower values. Lowest level is 0.\r\n")
    private Integer stackLevel;
    @JsonProperty(value="chargingProfileId")
    @JsonPropertyDescription(value="List of all the chargingProfileIds requested. Any ChargingProfile that matches one of these profiles will be reported. If omitted, the Charging Station SHALL not filter on chargingProfileId. This field SHALL NOT contain more ids than set in &lt;&lt;configkey-charging-profile-entries,ChargingProfileEntries.maxLimit&gt;&gt;\r\n\r\n")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<Integer> chargingProfileId = new ArrayList<Integer>();
    @JsonProperty(value="chargingLimitSource")
    @JsonPropertyDescription(value="For which charging limit sources, charging profiles SHALL be reported. If omitted, the Charging Station SHALL not filter on chargingLimitSource.\r\n")
    @Size(min=1, max=4)
    @Valid
    private @Size(min=1, max=4) @Valid List<ChargingLimitSourceEnum> chargingLimitSource = new ArrayList<ChargingLimitSourceEnum>();

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ChargingProfileCriterion withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="chargingProfilePurpose")
    public ChargingProfilePurposeEnum getChargingProfilePurpose() {
        return this.chargingProfilePurpose;
    }

    @JsonProperty(value="chargingProfilePurpose")
    public void setChargingProfilePurpose(ChargingProfilePurposeEnum chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
    }

    public ChargingProfileCriterion withChargingProfilePurpose(ChargingProfilePurposeEnum chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
        return this;
    }

    @JsonProperty(value="stackLevel")
    public Integer getStackLevel() {
        return this.stackLevel;
    }

    @JsonProperty(value="stackLevel")
    public void setStackLevel(Integer stackLevel) {
        this.stackLevel = stackLevel;
    }

    public ChargingProfileCriterion withStackLevel(Integer stackLevel) {
        this.stackLevel = stackLevel;
        return this;
    }

    @JsonProperty(value="chargingProfileId")
    public List<Integer> getChargingProfileId() {
        return this.chargingProfileId;
    }

    @JsonProperty(value="chargingProfileId")
    public void setChargingProfileId(List<Integer> chargingProfileId) {
        this.chargingProfileId = chargingProfileId;
    }

    public ChargingProfileCriterion withChargingProfileId(List<Integer> chargingProfileId) {
        this.chargingProfileId = chargingProfileId;
        return this;
    }

    @JsonProperty(value="chargingLimitSource")
    public List<ChargingLimitSourceEnum> getChargingLimitSource() {
        return this.chargingLimitSource;
    }

    @JsonProperty(value="chargingLimitSource")
    public void setChargingLimitSource(List<ChargingLimitSourceEnum> chargingLimitSource) {
        this.chargingLimitSource = chargingLimitSource;
    }

    public ChargingProfileCriterion withChargingLimitSource(List<ChargingLimitSourceEnum> chargingLimitSource) {
        this.chargingLimitSource = chargingLimitSource;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChargingProfileCriterion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("chargingProfilePurpose");
        sb.append('=');
        sb.append(this.chargingProfilePurpose == null ? "<null>" : this.chargingProfilePurpose);
        sb.append(',');
        sb.append("stackLevel");
        sb.append('=');
        sb.append(this.stackLevel == null ? "<null>" : this.stackLevel);
        sb.append(',');
        sb.append("chargingProfileId");
        sb.append('=');
        sb.append(this.chargingProfileId == null ? "<null>" : this.chargingProfileId);
        sb.append(',');
        sb.append("chargingLimitSource");
        sb.append('=');
        sb.append(this.chargingLimitSource == null ? "<null>" : this.chargingLimitSource);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.chargingProfilePurpose == null ? 0 : this.chargingProfilePurpose.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.stackLevel == null ? 0 : this.stackLevel.hashCode());
        result = result * 31 + (this.chargingProfileId == null ? 0 : this.chargingProfileId.hashCode());
        result = result * 31 + (this.chargingLimitSource == null ? 0 : this.chargingLimitSource.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChargingProfileCriterion)) {
            return false;
        }
        ChargingProfileCriterion rhs = (ChargingProfileCriterion)other;
        return (this.chargingProfilePurpose == rhs.chargingProfilePurpose || this.chargingProfilePurpose != null && this.chargingProfilePurpose.equals((Object)rhs.chargingProfilePurpose)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.stackLevel == rhs.stackLevel || this.stackLevel != null && this.stackLevel.equals(rhs.stackLevel)) && (this.chargingProfileId == rhs.chargingProfileId || this.chargingProfileId != null && this.chargingProfileId.equals(rhs.chargingProfileId)) && (this.chargingLimitSource == rhs.chargingLimitSource || this.chargingLimitSource != null && this.chargingLimitSource.equals(rhs.chargingLimitSource));
    }
}

