/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib;

import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import com.github.stephenc.javaisotools.sabre.impl.DWordDataReference;
import com.github.stephenc.javaisotools.sabre.impl.FileDataReference;
import com.github.stephenc.javaisotools.sabre.impl.WordDataReference;
import com.github.stephenc.javaisotools.udflib.SabreUDFElement;
import com.github.stephenc.javaisotools.udflib.UDFImageBuilderFile;
import com.github.stephenc.javaisotools.udflib.UDFLayoutInformation;
import java.io.File;

public class SabreUDFElementFactory {
    private StreamHandler myStreamHandler = null;

    public SabreUDFElementFactory(StreamHandler myStreamHandler) {
        this.myStreamHandler = myStreamHandler;
    }

    public void startUDFImage() throws HandlerException {
        this.myStreamHandler.startDocument();
    }

    public void endUDFImage() throws HandlerException {
        this.myStreamHandler.endDocument();
    }

    public void startReservedArea() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.ReservedArea));
        this.myStreamHandler.data(new ByteArrayDataReference(new byte[32768]));
    }

    public void endReservedArea() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startVRS() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.VolumeRecognitionSequence));
    }

    public void endVRS() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startEmptyArea() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.EmptyArea));
    }

    public void doEmptyArea(int lengthInBytes) throws HandlerException {
        this.myStreamHandler.data(new ByteArrayDataReference(new byte[lengthInBytes]));
    }

    public void endEmptyArea() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startAVDP() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.AnchorVolumeDescriptorPointer));
    }

    public void doAVDP(long selfBlock, long MVDSBlock, long RVDSBlock) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(MVDSBlock));
        this.myStreamHandler.data(new WordDataReference(RVDSBlock));
    }

    public void endAVDP() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startPVD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.PrimaryVolumeDescriptor));
    }

    public void doPVD(long selfBlock, long volumeDescriptorSequenceNumber, long recordingTimeMillis, String imageIdentifier, String applicationIdentifier, byte[] applicationIdentifierSuffix) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(volumeDescriptorSequenceNumber));
        this.myStreamHandler.data(new DWordDataReference(recordingTimeMillis));
        this.myStreamHandler.data(new ByteArrayDataReference(imageIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
    }

    public void endPVD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startPD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.PartitionDescriptor));
    }

    public void doPD(long selfBlock, long volumeDescriptorSequenceNumber, long partitionStartingBlock, long partitionEndingBlock, String applicationIdentifier, byte[] applicationIdentifierSuffix) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(volumeDescriptorSequenceNumber));
        this.myStreamHandler.data(new WordDataReference(partitionStartingBlock));
        this.myStreamHandler.data(new WordDataReference(partitionEndingBlock));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
    }

    public void endPD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startLVD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.LogicalVolumeDescriptor));
    }

    public void doLVD(long selfBlock, long volumeDescriptorSequenceNumber, long logicalVolumeIntegritySequenceStartingBlock, long logicalVolumeIntegritySequenceEndingBlock, int metadataAllocationUnitSize, int metadataAlignmentUnitSize, long mainMetadataFileLocation, long mirrorMetadataFileLocation, int fileSetDescriptorPartition, long fileSetDescriptorLocation, String applicationIdentifier, byte[] applicationIdentifierSuffix, String imageIdentifier) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(volumeDescriptorSequenceNumber));
        this.myStreamHandler.data(new WordDataReference(logicalVolumeIntegritySequenceStartingBlock));
        this.myStreamHandler.data(new WordDataReference(logicalVolumeIntegritySequenceEndingBlock));
        this.myStreamHandler.data(new WordDataReference(metadataAllocationUnitSize));
        this.myStreamHandler.data(new WordDataReference(metadataAlignmentUnitSize));
        this.myStreamHandler.data(new WordDataReference(mainMetadataFileLocation));
        this.myStreamHandler.data(new WordDataReference(mirrorMetadataFileLocation));
        this.myStreamHandler.data(new WordDataReference(fileSetDescriptorPartition));
        this.myStreamHandler.data(new WordDataReference(fileSetDescriptorLocation));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
        this.myStreamHandler.data(new ByteArrayDataReference(imageIdentifier.getBytes()));
    }

    public void endLVD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startUSD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.UnallocatedSpaceDescriptor));
    }

    public void doUSD(long selfBlock, long volumeDescriptorSequenceNumber, long unallocatedSpaceStartBlock, long unallocatedSpaceEndBlock) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(volumeDescriptorSequenceNumber));
        this.myStreamHandler.data(new WordDataReference(unallocatedSpaceStartBlock));
        this.myStreamHandler.data(new WordDataReference(unallocatedSpaceEndBlock));
    }

    public void endUSD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startIUVD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.ImplementationUseVolumeDescriptor));
    }

    public void doIUVD(long selfBlock, long volumeDescriptorSequenceNumber, String applicationIdentifier, byte[] applicationIdentifierSuffix, String imageIdentifier) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(volumeDescriptorSequenceNumber));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
        this.myStreamHandler.data(new ByteArrayDataReference(imageIdentifier.getBytes()));
    }

    public void endIUVD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startTD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.TerminatingDescriptor));
    }

    public void doTD(long selfBlock) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
    }

    public void endTD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startLVID() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.LogicalVolumeIntegrityDescriptor));
    }

    public void doLVID(long selfBlock, long recordingTimeMillis, long numberOfFiles, long numberOfDirectories, String applicationIdentifier, byte[] applicationIdentifierSuffix, long[] sizeTable, long[] freespaceTable, long nextUniqueId) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new DWordDataReference(recordingTimeMillis));
        this.myStreamHandler.data(new WordDataReference(numberOfFiles));
        this.myStreamHandler.data(new WordDataReference(numberOfDirectories));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
        for (int i = 0; i < sizeTable.length; ++i) {
            this.myStreamHandler.data(new WordDataReference(sizeTable[i]));
            this.myStreamHandler.data(new WordDataReference(freespaceTable[i]));
        }
        this.myStreamHandler.data(new WordDataReference(sizeTable.length));
        this.myStreamHandler.data(new WordDataReference(nextUniqueId));
    }

    public void endLVID() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startFSD() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.FileSetDescriptor));
    }

    public void doFSD(long selfBlock, long recordingTimeMillis, long rootDirectoryLocation, int partitionToStoreMetadataOn, String imageIdentifier) throws HandlerException {
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new DWordDataReference(recordingTimeMillis));
        this.myStreamHandler.data(new WordDataReference(rootDirectoryLocation));
        this.myStreamHandler.data(new WordDataReference(partitionToStoreMetadataOn));
        this.myStreamHandler.data(new ByteArrayDataReference(imageIdentifier.getBytes()));
    }

    public void endFSD() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startFE() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.FileEntry));
    }

    public void doFE(UDFImageBuilderFile myUDFImageBuilderFile, UDFLayoutInformation myUDFLayoutInformation, String applicationIdentifier, byte[] applicationIdentifierSuffix) throws HandlerException {
        long selfBlock = myUDFLayoutInformation.fileEntryPositions.get((Object)myUDFImageBuilderFile).entryLocation;
        long dataLocation = myUDFLayoutInformation.fileEntryPositions.get((Object)myUDFImageBuilderFile).dataLocation;
        long uniqueId = myUDFLayoutInformation.uniqueIds.get(myUDFImageBuilderFile);
        int fileLinkCount = myUDFImageBuilderFile.getFileLinkCount();
        long accessTimeMillis = myUDFImageBuilderFile.getAccessTime().getTimeInMillis();
        long modificationTimeMillis = myUDFImageBuilderFile.getModificationTime().getTimeInMillis();
        long attributeTimeMillis = myUDFImageBuilderFile.getAttributeTime().getTimeInMillis();
        long creationTimeMillis = myUDFImageBuilderFile.getCreationTime().getTimeInMillis();
        int fileType = -1;
        if (myUDFImageBuilderFile.getFileType() == UDFImageBuilderFile.FileType.File) {
            fileType = 0;
        } else if (myUDFImageBuilderFile.getFileType() == UDFImageBuilderFile.FileType.Directory) {
            fileType = 1;
        }
        if (myUDFImageBuilderFile.getFileType() == UDFImageBuilderFile.FileType.File) {
            this.myStreamHandler.data(new FileDataReference(myUDFImageBuilderFile.getSourceFile()));
            this.myStreamHandler.data(new WordDataReference(dataLocation));
        } else if (myUDFImageBuilderFile.getFileType() == UDFImageBuilderFile.FileType.Directory) {
            UDFImageBuilderFile[] childUDFImageBuilderFiles = myUDFImageBuilderFile.getChilds();
            for (int i = childUDFImageBuilderFiles.length - 1; i >= 0; --i) {
                long childFileUniqueId = myUDFLayoutInformation.uniqueIds.get(childUDFImageBuilderFiles[i]);
                long childFileLocation = myUDFLayoutInformation.fileEntryPositions.get((Object)childUDFImageBuilderFiles[i]).entryLocation;
                int childFileType = -1;
                if (childUDFImageBuilderFiles[i].getFileType() == UDFImageBuilderFile.FileType.File) {
                    childFileType = 0;
                } else if (childUDFImageBuilderFiles[i].getFileType() == UDFImageBuilderFile.FileType.Directory) {
                    childFileType = 1;
                }
                this.myStreamHandler.data(new DWordDataReference(childFileUniqueId));
                this.myStreamHandler.data(new WordDataReference(childFileLocation));
                this.myStreamHandler.data(new ByteArrayDataReference(childUDFImageBuilderFiles[i].getIdentifier().getBytes()));
                this.myStreamHandler.data(new WordDataReference(childFileType));
            }
            this.myStreamHandler.data(new WordDataReference(childUDFImageBuilderFiles.length));
            long parentDirectoryUniqueId = 0L;
            long parentDirectoryLocation = myUDFLayoutInformation.fileEntryPositions.get((Object)myUDFImageBuilderFile).entryLocation;
            if (myUDFImageBuilderFile.getParent() != null) {
                parentDirectoryUniqueId = myUDFLayoutInformation.uniqueIds.get(myUDFImageBuilderFile.getParent());
                parentDirectoryLocation = myUDFLayoutInformation.fileEntryPositions.get((Object)myUDFImageBuilderFile.getParent()).entryLocation;
            }
            this.myStreamHandler.data(new DWordDataReference(parentDirectoryUniqueId));
            this.myStreamHandler.data(new WordDataReference(parentDirectoryLocation));
            this.myStreamHandler.data(new WordDataReference(myUDFLayoutInformation.partitionToStoreMetadataOn));
            this.myStreamHandler.data(new WordDataReference(dataLocation));
        }
        this.myStreamHandler.data(new WordDataReference(selfBlock));
        this.myStreamHandler.data(new WordDataReference(fileLinkCount));
        this.myStreamHandler.data(new DWordDataReference(accessTimeMillis));
        this.myStreamHandler.data(new DWordDataReference(modificationTimeMillis));
        this.myStreamHandler.data(new DWordDataReference(attributeTimeMillis));
        this.myStreamHandler.data(new DWordDataReference(creationTimeMillis));
        this.myStreamHandler.data(new DWordDataReference(uniqueId));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
        this.myStreamHandler.data(new WordDataReference(fileType));
        this.myStreamHandler.data(new WordDataReference(myUDFLayoutInformation.partitionToStoreMetadataOn));
    }

    public void endFE() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startRawFileData() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.RawFileData));
    }

    public void doRawFileData(File sourceFile) throws HandlerException {
        this.myStreamHandler.data(new FileDataReference(sourceFile));
    }

    public void endRawFileData() throws HandlerException {
        this.myStreamHandler.endElement();
    }

    public void startMetadataFile() throws HandlerException {
        this.myStreamHandler.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.MetadataFile));
    }

    public void doMetadataFile(long recordingTimeMillis, String applicationIdentifier, byte[] applicationIdentifierSuffix, UDFLayoutInformation myUDFLayoutInformation, long metadataFileLocation, byte fileType) throws HandlerException {
        this.myStreamHandler.data(new DWordDataReference(recordingTimeMillis));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifier.getBytes()));
        this.myStreamHandler.data(new ByteArrayDataReference(applicationIdentifierSuffix));
        this.myStreamHandler.data(new WordDataReference(myUDFLayoutInformation.metadataPartitionStartingBlock));
        this.myStreamHandler.data(new WordDataReference(myUDFLayoutInformation.metadataPartitionEndingBlock));
        this.myStreamHandler.data(new WordDataReference(myUDFLayoutInformation.physicalPartitionStartingBlock));
        this.myStreamHandler.data(new WordDataReference(metadataFileLocation));
        this.myStreamHandler.data(new ByteDataReference(fileType));
    }

    public void endMetadataFile() throws HandlerException {
        this.myStreamHandler.endElement();
    }
}

