package com.eaio.picocontainer.web.remoting;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.web.remoting.AbstractPicoWebRemotingServlet;
import org.picocontainer.web.remoting.NullPicoWebRemotingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PWR doesn't log any exceptions by default (see {@link AbstractPicoWebRemotingServlet#publishAdapters()}). This
 * clearly sucks.
 * 
 * @author <a href="mailto:jb&#64;eaio.com">Johann Burkard</a>
 * @version $Id: LoggingPicoWebRemotingMonitor.java 5187 2012-10-01 16:42:54Z johann $
 */
public class LoggingPicoWebRemotingMonitor extends NullPicoWebRemotingMonitor {

    private Logger LOG = LoggerFactory.getLogger(LoggingPicoWebRemotingMonitor.class);

    public Object picoCompositionExceptionForMethodInvocation(PicoCompositionException e) {
        if (!(ExceptionUtils.getRootCause(e) instanceof InterruptedException)) {
            LOG.error("caught PicoCompositionException", ExceptionUtils.getRootCause(e));
        }
        return super.picoCompositionExceptionForMethodInvocation(e);
    }

}
