/**
 * 
 */
package com.eaio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Serves only a slice of the original input stream. Can be used for <tt>Range</tt> requests.
 * <p>
 * Don't fuck with this class because <tt>Range</tt> requests are so bizarre, there's only one way to get them right.
 *
 * @author <a href="mailto:jb&#64;eaio.com">Johann Burkard</a>
 * @version $Id: RangeInputStream.java 5109 2012-08-22 11:06:00Z johann $
 */
public class RangeInputStream extends FilterInputStream {
    
    private long remaining;

    /**
     * @param in the original input stream
     * @param start the start position
     */
    public RangeInputStream(InputStream in, long start) throws IOException {
        super(in);
        assert start >= 0;
        in.skip(start);
        this.remaining = -1;
    }
    
    /**
     * @param in the original input stream
     * @param start the start position
     * @param end the end position
     */
    public RangeInputStream(InputStream in, long start, long end) throws IOException {
        super(in);
        assert start >= 0;
        assert end > start;
        long skipped = in.skip(start);
        this.remaining = end - skipped;
    }

    /**
     * @see java.io.FilterInputStream#available()
     */
    public int available() throws IOException {
        int av = in.available();
        if (remaining != -1 && av > (int) remaining) {
            return (int) remaining;
        }
        return av;
    }

    /**
     * @see java.io.FilterInputStream#read()
     */
    public int read() throws IOException {
        if (remaining == 0) {
            return -1;
        }
        if (remaining == -1) {
            return in.read();
        }
        int out = in.read();
        --remaining;
        return out;
    }

    /**
     * @see java.io.FilterInputStream#read(byte[], int, int)
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (remaining == 0) {
            return -1;
        }
        if (remaining == -1) {
            return in.read(b, off, len);
        }
        int out;
        if (len <= remaining) {
            out = in.read(b, off, len);
            remaining -= len;
        }
        else {
            out = (int) remaining;
            in.read(b, off, (int) remaining);
            remaining = 0;
        }
        return out;
    }

}
