/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.statsig.androidsdk.Endpoint;
import com.statsig.androidsdk.StatsigNetworkConfigKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020\u0005R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0005j\u0002`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/statsig/androidsdk/UrlConfig;", "", "endpoint", "Lcom/statsig/androidsdk/Endpoint;", "inputApi", "", "userFallbackUrls", "", "(Lcom/statsig/androidsdk/Endpoint;Ljava/lang/String;Ljava/util/List;)V", "customUrl", "getCustomUrl", "()Ljava/lang/String;", "setCustomUrl", "(Ljava/lang/String;)V", "defaultUrl", "getDefaultUrl", "setDefaultUrl", "getEndpoint", "()Lcom/statsig/androidsdk/Endpoint;", "endpointDnsKey", "Lcom/statsig/androidsdk/EndpointDnsKey;", "getEndpointDnsKey", "fallbackUrl", "getFallbackUrl", "setFallbackUrl", "statsigFallbackUrl", "getStatsigFallbackUrl", "setStatsigFallbackUrl", "getUserFallbackUrls", "()Ljava/util/List;", "setUserFallbackUrls", "(Ljava/util/List;)V", "getUrl", "android-sdk_release"})
public final class UrlConfig {
    @NotNull
    private final Endpoint endpoint;
    @Nullable
    private List<String> userFallbackUrls;
    @NotNull
    private final String endpointDnsKey;
    @NotNull
    private String defaultUrl;
    @Nullable
    private String customUrl;
    @Nullable
    private String statsigFallbackUrl;
    @Nullable
    private String fallbackUrl;

    public UrlConfig(@NotNull Endpoint endpoint, @Nullable String inputApi, @Nullable List<String> userFallbackUrls) {
        char[] cArray;
        String inputUrl;
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        this.endpoint = endpoint;
        this.userFallbackUrls = userFallbackUrls;
        String string = StatsigNetworkConfigKt.getENDPOINT_DNS_KEY_MAP().get((Object)this.endpoint);
        if (string == null) {
            string = "";
        }
        this.endpointDnsKey = string;
        String defaultApi = StatsigNetworkConfigKt.getNetworkDefault().get((Object)this.endpoint);
        this.defaultUrl = defaultApi + this.endpoint.getValue();
        if (this.customUrl == null && inputApi != null && !Intrinsics.areEqual((Object)(inputUrl = StringsKt.trimEnd((String)inputApi, (char[])(cArray = new char[]{'/'})) + "/" + this.endpoint.getValue()), (Object)this.defaultUrl)) {
            this.customUrl = inputUrl;
        }
    }

    public /* synthetic */ UrlConfig(Endpoint endpoint, String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        this(endpoint, string, list);
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public final List<String> getUserFallbackUrls() {
        return this.userFallbackUrls;
    }

    public final void setUserFallbackUrls(@Nullable List<String> list) {
        this.userFallbackUrls = list;
    }

    @NotNull
    public final String getEndpointDnsKey() {
        return this.endpointDnsKey;
    }

    @NotNull
    public final String getDefaultUrl() {
        return this.defaultUrl;
    }

    public final void setDefaultUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultUrl = string;
    }

    @Nullable
    public final String getCustomUrl() {
        return this.customUrl;
    }

    public final void setCustomUrl(@Nullable String string) {
        this.customUrl = string;
    }

    @Nullable
    public final String getStatsigFallbackUrl() {
        return this.statsigFallbackUrl;
    }

    public final void setStatsigFallbackUrl(@Nullable String string) {
        this.statsigFallbackUrl = string;
    }

    @Nullable
    public final String getFallbackUrl() {
        return this.fallbackUrl;
    }

    public final void setFallbackUrl(@Nullable String string) {
        this.fallbackUrl = string;
    }

    @NotNull
    public final String getUrl() {
        String string = this.customUrl;
        if (string == null) {
            string = this.defaultUrl;
        }
        return string;
    }
}

