/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.util.Log;
import com.statsig.androidsdk.CoroutineDispatcherProvider;
import com.statsig.androidsdk.DnsTxtParseError;
import com.statsig.androidsdk.DnsTxtQueryKt;
import com.statsig.androidsdk.HttpUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0017\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"DNS_QUERY_ENDPOINT", "", "DOMAIN_CHARS", "", "", "getDOMAIN_CHARS", "()Ljava/util/List;", "FEATURE_ASSETS_DNS_QUERY", "", "getFEATURE_ASSETS_DNS_QUERY", "()[B", "MAX_START_LOOKUP", "", "TAG", "coroutineDispatcherProvider", "Lcom/statsig/androidsdk/CoroutineDispatcherProvider;", "getCoroutineDispatcherProvider", "()Lcom/statsig/androidsdk/CoroutineDispatcherProvider;", "coroutineDispatcherProvider$delegate", "Lkotlin/Lazy;", "fetchTxtRecords", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseDnsResponse", "input", "android-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDnsTxtQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsTxtQuery.kt\ncom/statsig/androidsdk/DnsTxtQueryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n346#2,8:62\n*S KotlinDebug\n*F\n+ 1 DnsTxtQuery.kt\ncom/statsig/androidsdk/DnsTxtQueryKt\n*L\n44#1:62,8\n*E\n"})
public final class DnsTxtQueryKt {
    @NotNull
    private static final byte[] FEATURE_ASSETS_DNS_QUERY;
    @NotNull
    public static final String DNS_QUERY_ENDPOINT = "https://cloudflare-dns.com/dns-query";
    @NotNull
    private static final List<Character> DOMAIN_CHARS;
    public static final int MAX_START_LOOKUP = 200;
    @NotNull
    private static final Lazy coroutineDispatcherProvider$delegate;
    @NotNull
    private static final String TAG;

    @NotNull
    public static final byte[] getFEATURE_ASSETS_DNS_QUERY() {
        return FEATURE_ASSETS_DNS_QUERY;
    }

    @NotNull
    public static final List<Character> getDOMAIN_CHARS() {
        return DOMAIN_CHARS;
    }

    private static final CoroutineDispatcherProvider getCoroutineDispatcherProvider() {
        Lazy lazy = coroutineDispatcherProvider$delegate;
        return (CoroutineDispatcherProvider)lazy.getValue();
    }

    @Nullable
    public static final Object fetchTxtRecords(@NotNull Continuation<? super List<String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)DnsTxtQueryKt.getCoroutineDispatcherProvider().getIo()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(null){
            int label;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Request request = new Request.Builder().url("https://cloudflare-dns.com/dns-query").post(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])DnsTxtQueryKt.getFEATURE_ASSETS_DNS_QUERY(), null, (int)0, (int)0, (int)7, null)).addHeader("Content-Type", "application/dns-message").addHeader("Accept", "application/dns-message").addHeader("CONNECTION", "CLOSE").build();
                        try (Response response = HttpUtils.Companion.getHttpClient$android_sdk_release().newCall(request).execute();){
                            ResponseBody responseBody = response.body();
                            Intrinsics.checkNotNull((Object)responseBody);
                            List<String> list = DnsTxtQueryKt.parseDnsResponse(responseBody.bytes());
                            return list;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public static final List<String> parseDnsResponse(@NotNull byte[] input) {
        int startIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable $this$indexOfFirst$iv = ArraysKt.withIndex((byte[])input);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IndexedValue indexedValue = (IndexedValue)item$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                byte by = ((Number)indexedValue.component2()).byteValue();
                boolean bl2 = index < 200 && (char)by == '=' && index > 0 && DOMAIN_CHARS.contains(Character.valueOf((char)input[index - 1]));
                if (bl2) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == -1) {
            throw new DnsTxtParseError("Failed to parse TXT records from DNS");
        }
        Object[] objectArray = input;
        int n = startIndex - 1;
        int n2 = input.length;
        objectArray = ArraysKt.copyOfRange((byte[])objectArray, (int)n, (int)n2);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String result = new String((byte[])objectArray, charset2);
        Log.v((String)TAG, (String)("Parsed response: " + result));
        objectArray = new String[1];
        objectArray[0] = (byte)",";
        return StringsKt.split$default((CharSequence)result, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
    }

    static {
        Object[] objectArray = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 13, 102, 101, 97, 116, 117, 114, 101, 97, 115, 115, 101, 116, 115, 3, 111, 114, 103, 0, 0, 16, 0, 1};
        FEATURE_ASSETS_DNS_QUERY = objectArray;
        objectArray = new Character[3];
        objectArray[0] = (byte)Character.valueOf('i');
        objectArray[1] = (byte)Character.valueOf('e');
        objectArray[2] = (byte)Character.valueOf('d');
        DOMAIN_CHARS = CollectionsKt.listOf((Object[])objectArray);
        coroutineDispatcherProvider$delegate = LazyKt.lazy((Function0)coroutineDispatcherProvider.2.INSTANCE);
        TAG = "statsig::DnsTxtQuery";
    }
}

