/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.statsig.androidsdk.StatsigUser;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\f2\u0010\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/statsig/androidsdk/BootstrapValidator;", "", "<init>", "()V", "isValid", "", "initializeValues", "", "", "user", "Lcom/statsig/androidsdk/StatsigUser;", "getUserIdentifier", "", "customIDs", "android-sdk_release"})
public final class BootstrapValidator {
    @NotNull
    public static final BootstrapValidator INSTANCE = new BootstrapValidator();

    private BootstrapValidator() {
    }

    public final boolean isValid(@NotNull Map<String, ? extends Object> initializeValues, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter(initializeValues, (String)"initializeValues");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        try {
            Object object = initializeValues.get("evaluated_keys");
            Map map = object instanceof Map ? (Map)object : null;
            if (map == null) {
                return true;
            }
            Map evaluatedKeys = map;
            Map<String, String> userCopy = this.getUserIdentifier(user.getCustomIDs());
            if (user.getUserID() != null) {
                userCopy.put("userID", user.getUserID());
            }
            Map<String, String> evaluatedKeyCopy = this.getUserIdentifier(evaluatedKeys);
            return Intrinsics.areEqual(userCopy, evaluatedKeyCopy);
        }
        catch (Exception e) {
            return true;
        }
    }

    private final Map<String, String> getUserIdentifier(Map<?, ?> customIDs) {
        Map result = new LinkedHashMap();
        if (customIDs == null) {
            return result;
        }
        for (Map.Entry<?, ?> entry : customIDs.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (Intrinsics.areEqual(key, (Object)"stableID") || !(key instanceof String)) continue;
            Object obj = value = entry.getValue();
            if (obj == null ? true : obj instanceof String) {
                result.put(key, value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map<String, String> flattenMap = this.getUserIdentifier((Map)value);
            result.putAll(flattenMap);
        }
        return result;
    }
}

