/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.google.gson.Gson;
import com.statsig.androidsdk.LogEvent;
import com.statsig.androidsdk.NetworkKt;
import com.statsig.androidsdk.StatsigMetadata;
import com.statsig.androidsdk.StatsigUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\fJ \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/statsig/androidsdk/StatsigLogger;", "", "sdkKey", "", "api", "statsigMetadata", "Lcom/statsig/androidsdk/StatsigMetadata;", "(Ljava/lang/String;Ljava/lang/String;Lcom/statsig/androidsdk/StatsigMetadata;)V", "configExposures", "", "events", "", "Lcom/statsig/androidsdk/LogEvent;", "gateExposures", "flush", "", "log", "event", "logConfigExposure", "configName", "group", "user", "Lcom/statsig/androidsdk/StatsigUser;", "logGateExposure", "gateName", "value", "", "build_release"})
public final class StatsigLogger {
    private List<LogEvent> events;
    private final Set<String> gateExposures;
    private final Set<String> configExposures;
    private final String sdkKey;
    private final String api;
    private final StatsigMetadata statsigMetadata;

    public final void log(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.events.add(event);
        if (this.events.size() >= 500) {
            this.flush();
        }
        if (this.events.size() == 1) {
            StatsigLogger logger = this;
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logger, null){
                int label;
                final /* synthetic */ StatsigLogger $logger;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)10000L, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.$logger.flush();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$logger = statsigLogger;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final synchronized void flush() {
        if (this.events.size() == 0) {
            return;
        }
        List flushEvents = new ArrayList(this.events.size());
        flushEvents.addAll((Collection)this.events);
        this.events = new ArrayList();
        Map metadata = MapsKt.mapOf((Pair)TuplesKt.to((Object)"sdkType", (Object)"statsig-kotlin-sdk"));
        Map body = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"events", (Object)flushEvents), TuplesKt.to((Object)"statsigMetadata", (Object)this.statsigMetadata)});
        String string = new Gson().toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(body)");
        NetworkKt.apiPostLogs(this.api, "log_event", this.sdkKey, string);
    }

    public final void logGateExposure(@NotNull String gateName, boolean value, @Nullable StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        if (this.gateExposures.contains(gateName)) {
            return;
        }
        this.gateExposures.add(gateName);
        LogEvent event = new LogEvent("statsig::gate_exposure");
        event.setUser(user);
        event.setMetadata(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"gate", (Object)gateName), TuplesKt.to((Object)"gateValue", (Object)value)}));
        this.log(event);
    }

    public final void logConfigExposure(@NotNull String configName, @NotNull String group, @Nullable StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (this.configExposures.contains(configName)) {
            return;
        }
        this.configExposures.add(configName);
        LogEvent event = new LogEvent("statsig::config_exposure");
        event.setUser(user);
        event.setMetadata(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"config", (Object)configName), TuplesKt.to((Object)"configGroup", (Object)group)}));
        this.log(event);
    }

    public StatsigLogger(@NotNull String sdkKey, @NotNull String api, @NotNull StatsigMetadata statsigMetadata) {
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)statsigMetadata, (String)"statsigMetadata");
        this.sdkKey = sdkKey;
        this.api = api;
        this.statsigMetadata = statsigMetadata;
        this.events = new ArrayList();
        this.gateExposures = new HashSet();
        this.configExposures = new HashSet();
    }
}

