/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.histquotes2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yahoofinance.Utils;
import yahoofinance.YahooFinance;
import yahoofinance.histquotes2.CrumbManager;
import yahoofinance.histquotes2.HistoricalDividend;
import yahoofinance.histquotes2.QueryInterval;
import yahoofinance.util.RedirectableRequest;

public class HistDividendsRequest {
    private static final Logger log = LoggerFactory.getLogger(HistDividendsRequest.class);
    private final String symbol;
    private final Calendar from;
    private final Calendar to;
    public static final Calendar DEFAULT_FROM = Calendar.getInstance();
    public static final Calendar DEFAULT_TO;
    public static final QueryInterval DEFAULT_INTERVAL;

    public HistDividendsRequest(String symbol) {
        this(symbol, DEFAULT_FROM, DEFAULT_TO);
    }

    public HistDividendsRequest(String symbol, Calendar from, Calendar to) {
        this.symbol = symbol;
        this.from = this.cleanHistCalendar(from);
        this.to = this.cleanHistCalendar(to);
    }

    public HistDividendsRequest(String symbol, Date from, Date to) {
        this(symbol);
        this.from.setTime(from);
        this.to.setTime(to);
        this.cleanHistCalendar(this.from);
        this.cleanHistCalendar(this.to);
    }

    private Calendar cleanHistCalendar(Calendar cal) {
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal;
    }

    public List<HistoricalDividend> getResult() throws IOException {
        ArrayList<HistoricalDividend> result = new ArrayList<HistoricalDividend>();
        if (this.from.after(this.to)) {
            log.warn("Unable to retrieve historical dividends. From-date should not be after to-date. From: " + this.from.getTime() + ", to: " + this.to.getTime());
            return result;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("period1", String.valueOf(this.from.getTimeInMillis() / 1000L));
        params.put("period2", String.valueOf(this.to.getTimeInMillis() / 1000L));
        params.put("interval", DEFAULT_INTERVAL.getTag());
        params.put("events", "div");
        params.put("crumb", CrumbManager.getCrumb());
        String url = YahooFinance.HISTQUOTES2_BASE_URL + URLEncoder.encode(this.symbol, "UTF-8") + "?" + Utils.getURLParameters(params);
        log.info("Sending request: " + url);
        URL request = new URL(url);
        RedirectableRequest redirectableRequest = new RedirectableRequest(request, 5);
        redirectableRequest.setConnectTimeout(YahooFinance.CONNECTION_TIMEOUT);
        redirectableRequest.setReadTimeout(YahooFinance.CONNECTION_TIMEOUT);
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Cookie", CrumbManager.getCookie());
        URLConnection connection = redirectableRequest.openConnection(requestProperties);
        InputStreamReader is = new InputStreamReader(connection.getInputStream());
        BufferedReader br = new BufferedReader(is);
        br.readLine();
        String line = br.readLine();
        while (line != null) {
            log.info("Parsing CSV line: " + Utils.unescape(line));
            HistoricalDividend dividend = this.parseCSVLine(line);
            result.add(dividend);
            line = br.readLine();
        }
        return result;
    }

    private HistoricalDividend parseCSVLine(String line) {
        String[] data = line.split(",");
        return new HistoricalDividend(this.symbol, Utils.parseHistDate(data[0]), Utils.getBigDecimal(data[1]));
    }

    static {
        DEFAULT_FROM.add(1, -1);
        DEFAULT_TO = Calendar.getInstance();
        DEFAULT_INTERVAL = QueryInterval.DAILY;
    }
}

