/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.media.AudioRecord;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveConfigKt;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\u000e"}, d2={"calculateAmplitude", "", "data", "", "audioFormat", "", "calculateDurationInMillis", "", "audioFile", "Ljava/io/File;", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "Ljava/math/BigDecimal;", "calculateMinBufferSize", "android-wave-recorder_release"})
public final class CalculateKt {
    public static final int calculateMinBufferSize(@NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        return AudioRecord.getMinBufferSize((int)waveConfig.getSampleRate(), (int)waveConfig.getChannels(), (int)waveConfig.getAudioEncoding());
    }

    public static final int calculateAmplitude(@NotNull byte[] data, int audioFormat) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return switch (audioFormat) {
            case 3 -> {
                double scaleFactor = 128.49803921568628;
                yield (int)((ArraysKt.average((byte[])data) + (double)128) * scaleFactor);
            }
            case 2 -> {
                short[] shortData = new short[data.length / 2];
                ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shortData);
                Short v1 = ArraysKt.maxOrNull((short[])shortData);
                if (v1 != null) {
                    yield v1.shortValue();
                }
                yield 0;
            }
            case 22 -> {
                int scaledAmplitude;
                int[] intData = new int[data.length / 4];
                ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(intData);
                Integer v2 = ArraysKt.maxOrNull((int[])intData);
                int maxAmplitude = v2 != null ? v2 : 0;
                yield scaledAmplitude = (int)((float)maxAmplitude / 2.1474836E9f * (float)32768);
            }
            default -> throw new IllegalArgumentException("Unsupported audio format for encoding " + audioFormat);
        };
    }

    public static final int calculateAmplitude(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Float f = ArraysKt.maxOrNull((float[])data);
        float maxFloatAmplitude = f != null ? f.floatValue() : 0.0f;
        return (int)(maxFloatAmplitude * (float)32768);
    }

    @NotNull
    public static final BigDecimal calculateDurationInMillis(@NotNull byte[] data, @NotNull WaveConfig waveConfig) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        switch (waveConfig.getAudioEncoding()) {
            case 3: {
                BigDecimal bigDecimal2 = new BigDecimal(data.length).divide(new BigDecimal(1 * WaveConfigKt.channelCount(waveConfig.getChannels()) * waveConfig.getSampleRate()), MathContext.DECIMAL64);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal(data.size).di\u2026t.DECIMAL64\n            )");
                BigDecimal bigDecimal3 = bigDecimal2;
                BigDecimal bigDecimal4 = new BigDecimal(1000);
                BigDecimal bigDecimal5 = bigDecimal3.multiply(bigDecimal4);
                bigDecimal = bigDecimal5;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.multiply(other)");
                break;
            }
            case 2: {
                BigDecimal bigDecimal6 = new BigDecimal(data.length).divide(new BigDecimal(2 * WaveConfigKt.channelCount(waveConfig.getChannels()) * waveConfig.getSampleRate()), MathContext.DECIMAL64);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"BigDecimal(data.size).di\u2026t.DECIMAL64\n            )");
                BigDecimal bigDecimal7 = bigDecimal6;
                BigDecimal bigDecimal8 = new BigDecimal(1000);
                BigDecimal bigDecimal9 = bigDecimal7.multiply(bigDecimal8);
                bigDecimal = bigDecimal9;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal9, (String)"this.multiply(other)");
                break;
            }
            case 22: {
                BigDecimal bigDecimal10 = new BigDecimal(data.length).divide(new BigDecimal(4 * WaveConfigKt.channelCount(waveConfig.getChannels()) * waveConfig.getSampleRate()), MathContext.DECIMAL64);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal10, (String)"BigDecimal(data.size).di\u2026t.DECIMAL64\n            )");
                BigDecimal bigDecimal11 = bigDecimal10;
                BigDecimal bigDecimal12 = new BigDecimal(1000);
                BigDecimal bigDecimal13 = bigDecimal11.multiply(bigDecimal12);
                bigDecimal = bigDecimal13;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal13, (String)"this.multiply(other)");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported audio format for encoding " + waveConfig.getAudioEncoding());
            }
        }
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal calculateDurationInMillis(@NotNull float[] data, @NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        BigDecimal bigDecimal = new BigDecimal(data.length).divide(new BigDecimal(WaveConfigKt.channelCount(waveConfig.getChannels()) * waveConfig.getSampleRate()), MathContext.DECIMAL64);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal(data.size).di\u2026thContext.DECIMAL64\n    )");
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = new BigDecimal(1000);
        BigDecimal bigDecimal4 = bigDecimal2.multiply(bigDecimal3);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"this.multiply(other)");
        return bigDecimal4;
    }

    public static final long calculateDurationInMillis(@NotNull File audioFile, @NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        int bytesPerSample = WaveConfigKt.bitPerSample(waveConfig.getAudioEncoding()) / 8;
        long totalSamplesRead = audioFile.length() / (long)bytesPerSample / (long)WaveConfigKt.channelCount(waveConfig.getChannels());
        return totalSamplesRead * (long)1000 / (long)waveConfig.getSampleRate();
    }
}

