/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioRecord;
import android.media.audiofx.NoiseSuppressor;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.github.squti.androidwaverecorder.CalculateKt;
import com.github.squti.androidwaverecorder.FileWriter;
import com.github.squti.androidwaverecorder.RecorderState;
import com.github.squti.androidwaverecorder.SilenceDetectionConfig;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveConfigKt;
import com.github.squti.androidwaverecorder.WaveHeaderWriter;
import com.github.squti.androidwaverecorder.WaveRecorder;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010?\u001a\u00020 2\u0006\u0010A\u001a\u00020\bJ\u0010\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020DH\u0002J\u001f\u0010E\u001a\u00020\u00002\u0017\u0010F\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\bGJ\u001f\u0010H\u001a\u00020\u00002\u0017\u0010F\u001a\u0013\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\bGJ\u0010\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\r2\u0006\u0010J\u001a\u00020MH\u0002J7\u0010N\u001a\u00020 2\u0006\u0010O\u001a\u00020\r2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020K0Q2\u0006\u0010J\u001a\u00020K2\u0006\u0010R\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010SJ7\u0010T\u001a\u00020 2\u0006\u0010O\u001a\u00020\r2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020M0Q2\u0006\u0010J\u001a\u00020M2\u0006\u0010R\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010UJ\b\u0010V\u001a\u00020 H\u0003J\b\u0010W\u001a\u00020\u0019H\u0002J\u0006\u0010X\u001a\u00020 J\u0006\u0010Y\u001a\u00020 J\u0006\u0010Z\u001a\u00020 J\u0006\u0010[\u001a\u00020 J!\u0010\\\u001a\u00020 2\u0006\u0010O\u001a\u00020\r2\u0006\u0010]\u001a\u00020)H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010^J\u0019\u0010_\u001a\u00020 2\u0006\u0010`\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJ\u0011\u0010b\u001a\u00020 H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010cJ\u0011\u0010d\u001a\u00020 H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010cR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R(\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R(\u0010(\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$R(\u0010,\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\"\"\u0004\b.\u0010$R\u001a\u0010/\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001b\"\u0004\b1\u0010\u001dR\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\n 6*\u0004\u0018\u00010505X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00107\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006e"}, d2={"Lcom/github/squti/androidwaverecorder/WaveRecorder;", "", "fileUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/net/Uri;Landroid/content/Context;)V", "filePath", "", "(Ljava/lang/String;)V", "audioRecorder", "Landroid/media/AudioRecord;", "<set-?>", "", "audioSessionId", "getAudioSessionId", "()I", "currentState", "Lcom/github/squti/androidwaverecorder/RecorderState;", "isPaused", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSkipping", "noiseSuppressor", "Landroid/media/audiofx/NoiseSuppressor;", "noiseSuppressorActive", "", "getNoiseSuppressorActive", "()Z", "setNoiseSuppressorActive", "(Z)V", "onAmplitudeListener", "Lkotlin/Function1;", "", "getOnAmplitudeListener", "()Lkotlin/jvm/functions/Function1;", "setOnAmplitudeListener", "(Lkotlin/jvm/functions/Function1;)V", "onStateChangeListener", "getOnStateChangeListener", "setOnStateChangeListener", "onTimeElapsed", "", "getOnTimeElapsed", "setOnTimeElapsed", "onTimeElapsedInMillis", "getOnTimeElapsedInMillis", "setOnTimeElapsedInMillis", "silenceDetection", "getSilenceDetection", "setSilenceDetection", "silenceDetectionConfig", "Lcom/github/squti/androidwaverecorder/SilenceDetectionConfig;", "silenceDuration", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "getWaveConfig$annotations", "()V", "getWaveConfig", "()Lcom/github/squti/androidwaverecorder/WaveConfig;", "setWaveConfig", "(Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "changeFilePath", "newFileUri", "newFilePath", "cleanup", "outputStream", "Ljava/io/OutputStream;", "configureSilenceDetection", "block", "Lkotlin/ExtensionFunctionType;", "configureWaveSettings", "getByteArrayAmplitude", "data", "", "getFloatArrayAmplitude", "", "handleByteSilenceState", "amplitude", "lastSkippedData", "Ljava/util/LinkedList;", "bufferSizeToKeep", "(ILjava/util/LinkedList;[BILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleFloatSilenceState", "(ILjava/util/LinkedList;[FILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeAudioRecorder", "isAudioRecorderInitialized", "pauseRecording", "resumeRecording", "startRecording", "stopRecording", "updateListeners", "fileDurationInMillis", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateState", "state", "(Lcom/github/squti/androidwaverecorder/RecorderState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeByteAudioDataToStorage", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeFloatAudioDataToStorage", "android-wave-recorder_release"})
@SourceDebugExtension(value={"SMAP\nWaveRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaveRecorder.kt\ncom/github/squti/androidwaverecorder/WaveRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1855#2,2:450\n1855#2,2:452\n1#3:454\n*S KotlinDebug\n*F\n+ 1 WaveRecorder.kt\ncom/github/squti/androidwaverecorder/WaveRecorder\n*L\n224#1:450,2\n280#1:452,2\n*E\n"})
public final class WaveRecorder {
    @Nullable
    private Uri fileUri;
    @Nullable
    private String filePath;
    private Context context;
    @NotNull
    private WaveConfig waveConfig;
    @NotNull
    private SilenceDetectionConfig silenceDetectionConfig;
    @Nullable
    private Function1<? super Integer, Unit> onAmplitudeListener;
    @Nullable
    private Function1<? super RecorderState, Unit> onStateChangeListener;
    @Nullable
    private Function1<? super Long, Unit> onTimeElapsed;
    @Nullable
    private Function1<? super Long, Unit> onTimeElapsedInMillis;
    private boolean noiseSuppressorActive;
    private int audioSessionId;
    private boolean silenceDetection;
    @NotNull
    private AtomicBoolean isPaused;
    @NotNull
    private AtomicBoolean isSkipping;
    private AudioRecord audioRecorder;
    @Nullable
    private NoiseSuppressor noiseSuppressor;
    private BigDecimal silenceDuration;
    @NotNull
    private RecorderState currentState;

    public WaveRecorder(@NotNull Uri fileUri, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.waveConfig = new WaveConfig(0, 0, 0, 7, null);
        this.silenceDetectionConfig = new SilenceDetectionConfig(1500, 0L, 0L, 6, null);
        this.audioSessionId = -1;
        this.isPaused = new AtomicBoolean(false);
        this.isSkipping = new AtomicBoolean(false);
        this.silenceDuration = BigDecimal.ZERO;
        this.currentState = RecorderState.STOP;
        this.fileUri = fileUri;
        this.context = context;
    }

    public WaveRecorder(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.waveConfig = new WaveConfig(0, 0, 0, 7, null);
        this.silenceDetectionConfig = new SilenceDetectionConfig(1500, 0L, 0L, 6, null);
        this.audioSessionId = -1;
        this.isPaused = new AtomicBoolean(false);
        this.isSkipping = new AtomicBoolean(false);
        this.silenceDuration = BigDecimal.ZERO;
        this.currentState = RecorderState.STOP;
        this.filePath = filePath;
    }

    @NotNull
    public final WaveConfig getWaveConfig() {
        return this.waveConfig;
    }

    public final void setWaveConfig(@NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"<set-?>");
        this.waveConfig = waveConfig;
    }

    @Deprecated(message="Use configureWaveSettings to set recording configuration. Access to this property will not be available in the future.")
    public static /* synthetic */ void getWaveConfig$annotations() {
    }

    @Nullable
    public final Function1<Integer, Unit> getOnAmplitudeListener() {
        return this.onAmplitudeListener;
    }

    public final void setOnAmplitudeListener(@Nullable Function1<? super Integer, Unit> function1) {
        this.onAmplitudeListener = function1;
    }

    @Nullable
    public final Function1<RecorderState, Unit> getOnStateChangeListener() {
        return this.onStateChangeListener;
    }

    public final void setOnStateChangeListener(@Nullable Function1<? super RecorderState, Unit> function1) {
        this.onStateChangeListener = function1;
    }

    @Nullable
    public final Function1<Long, Unit> getOnTimeElapsed() {
        return this.onTimeElapsed;
    }

    public final void setOnTimeElapsed(@Nullable Function1<? super Long, Unit> function1) {
        this.onTimeElapsed = function1;
    }

    @Nullable
    public final Function1<Long, Unit> getOnTimeElapsedInMillis() {
        return this.onTimeElapsedInMillis;
    }

    public final void setOnTimeElapsedInMillis(@Nullable Function1<? super Long, Unit> function1) {
        this.onTimeElapsedInMillis = function1;
    }

    public final boolean getNoiseSuppressorActive() {
        return this.noiseSuppressorActive;
    }

    public final void setNoiseSuppressorActive(boolean bl) {
        this.noiseSuppressorActive = bl;
    }

    public final int getAudioSessionId() {
        return this.audioSessionId;
    }

    public final boolean getSilenceDetection() {
        return this.silenceDetection;
    }

    public final void setSilenceDetection(boolean bl) {
        this.silenceDetection = bl;
    }

    @NotNull
    public final WaveRecorder configureWaveSettings(@NotNull Function1<? super WaveConfig, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        WaveConfig waveConfig = this.waveConfig;
        block.invoke((Object)waveConfig);
        return this;
    }

    @NotNull
    public final WaveRecorder configureSilenceDetection(@NotNull Function1<? super SilenceDetectionConfig, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SilenceDetectionConfig silenceDetectionConfig = this.silenceDetectionConfig;
        block.invoke((Object)silenceDetectionConfig);
        return this;
    }

    public final void startRecording() {
        if (!this.isAudioRecorderInitialized()) {
            this.initializeAudioRecorder();
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WaveRecorder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    void $result;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (this.this$0.getWaveConfig().getAudioEncoding() != 4) break;
                            if (Build.VERSION.SDK_INT < 23) throw new UnsupportedOperationException("Float audio is not supported on this version of Android. You need Android Android 6.0 or above");
                            this.label = 1;
                            Object object3 = WaveRecorder.access$writeFloatAudioDataToStorage(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    this.label = 2;
                    Object object4 = WaveRecorder.access$writeByteAudioDataToStorage(this.this$0, (Continuation)this);
                    if (object4 != object2) return Unit.INSTANCE;
                    return object2;
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private final void initializeAudioRecorder() {
        this.audioRecorder = new AudioRecord(1, this.waveConfig.getSampleRate(), this.waveConfig.getChannels(), this.waveConfig.getAudioEncoding(), AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding()));
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord = null;
        }
        this.audioSessionId = audioRecord.getAudioSessionId();
        AudioRecord audioRecord2 = this.audioRecorder;
        if (audioRecord2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord2 = null;
        }
        audioRecord2.startRecording();
        if (this.noiseSuppressorActive) {
            AudioRecord audioRecord3 = this.audioRecorder;
            if (audioRecord3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                audioRecord3 = null;
            }
            this.noiseSuppressor = NoiseSuppressor.create((int)audioRecord3.getAudioSessionId());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object writeByteAudioDataToStorage(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof writeByteAudioDataToStorage.1)) ** GOTO lbl-1000
        var20_2 = var1_1;
        if ((var20_2.label & -2147483648) != 0) {
            var20_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaveRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaveRecorder.access$writeByteAudioDataToStorage(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bufferSize = CalculateKt.calculateMinBufferSize(this.waveConfig);
                data = new byte[bufferSize];
                if (this.fileUri != null) {
                    v0 = this.context;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                        v0 = null;
                    }
                    v1 = this.fileUri;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    v2 = v0.getContentResolver().openOutputStream(v1);
                    if (v2 == null) {
                        return Unit.INSTANCE;
                    }
                } else {
                    v3 = this.filePath;
                    Intrinsics.checkNotNull((Object)v3);
                    file = new File(v3);
                    v2 = new FileOutputStream(file);
                }
                outputStream = v2;
                dataOutputStream = new DataOutputStream(outputStream);
                fileWriter = new FileWriter(dataOutputStream);
                bufferSizeToKeep = (int)((long)(this.waveConfig.getSampleRate() * WaveConfigKt.channelCount(this.waveConfig.getChannels()) * (WaveConfigKt.bitPerSample(this.waveConfig.getAudioEncoding()) / 8)) * this.silenceDetectionConfig.getBufferDurationInMillis() / (long)1000);
                lastSkippedData = new LinkedList<byte[]>();
                fileDurationInMillis = new Ref.ObjectRef();
                fileDurationInMillis.element = BigDecimal.ZERO;
lbl37:
                // 2 sources

                while (true) {
                    if ((v4 = this.audioRecorder) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        v4 = null;
                    }
                    if (v4.getRecordingState() != 3) break block0;
                    v5 = this.audioRecorder;
                    if (v5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        v5 = null;
                    }
                    if ((operationStatus = v5.read(data, 0, bufferSize)) == -3) continue;
                    amplitude = this.getByteArrayAmplitude(data);
                    if (!this.isPaused.get()) break block0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = data;
                    $continuation.L$2 = dataOutputStream;
                    $continuation.L$3 = fileWriter;
                    $continuation.L$4 = lastSkippedData;
                    $continuation.L$5 = fileDurationInMillis;
                    $continuation.I$0 = bufferSize;
                    $continuation.I$1 = bufferSizeToKeep;
                    $continuation.I$2 = amplitude;
                    $continuation.label = 1;
                    v6 = this.updateState(RecorderState.PAUSE, (Continuation<? super Unit>)$continuation);
                    if (v6 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl148
                    break;
                }
            }
            case 1: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                dataOutputStream = (DataOutputStream)$continuation.L$2;
                data = (byte[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                ** GOTO lbl148
            }
        }
        if (this.silenceDetection) {
            $continuation.L$0 = this;
            $continuation.L$1 = data;
            $continuation.L$2 = dataOutputStream;
            $continuation.L$3 = fileWriter;
            $continuation.L$4 = lastSkippedData;
            $continuation.L$5 = fileDurationInMillis;
            $continuation.I$0 = bufferSize;
            $continuation.I$1 = bufferSizeToKeep;
            $continuation.I$2 = amplitude;
            $continuation.label = 2;
            v7 = this.handleByteSilenceState(amplitude, lastSkippedData, data, bufferSizeToKeep, (Continuation<? super Unit>)$continuation);
            if (v7 == var21_4) {
                return var21_4;
            }
        }
        ** GOTO lbl103
        {
            case 2: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                dataOutputStream = (DataOutputStream)$continuation.L$2;
                data = (byte[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl103:
                // 2 sources

                if (this.isSkipping.get()) ** GOTO lbl148
                $continuation.L$0 = this;
                $continuation.L$1 = data;
                $continuation.L$2 = dataOutputStream;
                $continuation.L$3 = fileWriter;
                $continuation.L$4 = lastSkippedData;
                $continuation.L$5 = fileDurationInMillis;
                $continuation.I$0 = bufferSize;
                $continuation.I$1 = bufferSizeToKeep;
                $continuation.I$2 = amplitude;
                $continuation.label = 3;
                v8 = this.updateState(RecorderState.RECORDING, (Continuation<? super Unit>)$continuation);
                if (v8 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl130
            }
            case 3: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                dataOutputStream = (DataOutputStream)$continuation.L$2;
                data = (byte[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl130:
                // 2 sources

                $this$forEach$iv = lastSkippedData;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (byte[])element$iv;
                    $i$a$-forEach-WaveRecorder$writeByteAudioDataToStorage$2 = false;
                    v9 = fileDurationInMillis.element;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"fileDurationInMillis");
                    var18_21 = (BigDecimal)v9;
                    Intrinsics.checkNotNullExpressionValue((Object)var18_21.add(CalculateKt.calculateDurationInMillis(it, this.waveConfig)), (String)"this.add(other)");
                    fileDurationInMillis.element = fileDurationInMillis.element;
                }
                fileWriter.writeDataToStream(lastSkippedData, data);
                v10 = fileDurationInMillis.element;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"fileDurationInMillis");
                var12_15 = (BigDecimal)v10;
                Intrinsics.checkNotNullExpressionValue((Object)var12_15.add(CalculateKt.calculateDurationInMillis(data, this.waveConfig)), (String)"this.add(other)");
                fileDurationInMillis.element = fileDurationInMillis.element;
lbl148:
                // 4 sources

                $continuation.L$0 = this;
                $continuation.L$1 = data;
                $continuation.L$2 = dataOutputStream;
                $continuation.L$3 = fileWriter;
                $continuation.L$4 = lastSkippedData;
                $continuation.L$5 = fileDurationInMillis;
                $continuation.I$0 = bufferSize;
                $continuation.I$1 = bufferSizeToKeep;
                $continuation.label = 4;
                v11 = this.updateListeners(amplitude, ((BigDecimal)fileDurationInMillis.element).longValue(), (Continuation<? super Unit>)$continuation);
                if (v11 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl172
            }
            case 4: {
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList<byte[]>)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                dataOutputStream = (DataOutputStream)$continuation.L$2;
                data = (byte[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl172:
                // 2 sources

                ** continue;
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = dataOutputStream;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.label = 5;
        v12 = this.updateState(RecorderState.STOP, (Continuation<? super Unit>)$continuation);
        if (v12 == var21_4) {
            return var21_4;
        }
        ** GOTO lbl189
        {
            case 5: {
                dataOutputStream = (DataOutputStream)$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl189:
                // 2 sources

                this.cleanup(dataOutputStream);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @RequiresApi(value=23)
    private final Object writeFloatAudioDataToStorage(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof writeFloatAudioDataToStorage.1)) ** GOTO lbl-1000
        var20_2 = var1_1;
        if ((var20_2.label & -2147483648) != 0) {
            var20_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaveRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaveRecorder.access$writeFloatAudioDataToStorage(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bufferSize = CalculateKt.calculateMinBufferSize(this.waveConfig);
                data = new float[bufferSize];
                if (this.fileUri != null) {
                    v0 = this.context;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                        v0 = null;
                    }
                    v1 = this.fileUri;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    v2 = v0.getContentResolver().openOutputStream(v1);
                    if (v2 == null) {
                        return Unit.INSTANCE;
                    }
                } else {
                    v3 = this.filePath;
                    Intrinsics.checkNotNull((Object)v3);
                    file = new File(v3);
                    v2 = new FileOutputStream(file);
                }
                outputStream = v2;
                dataOutputStream = new DataOutputStream(outputStream);
                fileWriter = new FileWriter(dataOutputStream);
                bufferSizeToKeep = (int)((long)(this.waveConfig.getSampleRate() * WaveConfigKt.channelCount(this.waveConfig.getChannels())) * this.silenceDetectionConfig.getBufferDurationInMillis() / (long)1000);
                lastSkippedData = new LinkedList<float[]>();
                fileDurationInMillis = new Ref.ObjectRef();
                fileDurationInMillis.element = BigDecimal.ZERO;
lbl37:
                // 2 sources

                while (true) {
                    if ((v4 = this.audioRecorder) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        v4 = null;
                    }
                    if (v4.getRecordingState() != 3) break block0;
                    v5 = this.audioRecorder;
                    if (v5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        v5 = null;
                    }
                    if (-3 == (operationStatus = v5.read(data, 0, bufferSize, 0))) continue;
                    amplitude = this.getFloatArrayAmplitude(data);
                    if (!this.isPaused.get()) break block0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = data;
                    $continuation.L$2 = outputStream;
                    $continuation.L$3 = fileWriter;
                    $continuation.L$4 = lastSkippedData;
                    $continuation.L$5 = fileDurationInMillis;
                    $continuation.I$0 = bufferSize;
                    $continuation.I$1 = bufferSizeToKeep;
                    $continuation.I$2 = amplitude;
                    $continuation.label = 1;
                    v6 = this.updateState(RecorderState.PAUSE, (Continuation<? super Unit>)$continuation);
                    if (v6 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl148
                    break;
                }
            }
            case 1: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                outputStream = (OutputStream)$continuation.L$2;
                data = (float[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                ** GOTO lbl148
            }
        }
        if (this.silenceDetection) {
            $continuation.L$0 = this;
            $continuation.L$1 = data;
            $continuation.L$2 = outputStream;
            $continuation.L$3 = fileWriter;
            $continuation.L$4 = lastSkippedData;
            $continuation.L$5 = fileDurationInMillis;
            $continuation.I$0 = bufferSize;
            $continuation.I$1 = bufferSizeToKeep;
            $continuation.I$2 = amplitude;
            $continuation.label = 2;
            v7 = this.handleFloatSilenceState(amplitude, lastSkippedData, data, bufferSizeToKeep, (Continuation<? super Unit>)$continuation);
            if (v7 == var21_4) {
                return var21_4;
            }
        }
        ** GOTO lbl103
        {
            case 2: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                outputStream = (OutputStream)$continuation.L$2;
                data = (float[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl103:
                // 2 sources

                if (this.isSkipping.get()) ** GOTO lbl148
                $continuation.L$0 = this;
                $continuation.L$1 = data;
                $continuation.L$2 = outputStream;
                $continuation.L$3 = fileWriter;
                $continuation.L$4 = lastSkippedData;
                $continuation.L$5 = fileDurationInMillis;
                $continuation.I$0 = bufferSize;
                $continuation.I$1 = bufferSizeToKeep;
                $continuation.I$2 = amplitude;
                $continuation.label = 3;
                v8 = this.updateState(RecorderState.RECORDING, (Continuation<? super Unit>)$continuation);
                if (v8 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl130
            }
            case 3: {
                amplitude = $continuation.I$2;
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                outputStream = (OutputStream)$continuation.L$2;
                data = (float[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl130:
                // 2 sources

                $this$forEach$iv = lastSkippedData;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (float[])element$iv;
                    $i$a$-forEach-WaveRecorder$writeFloatAudioDataToStorage$2 = false;
                    v9 = fileDurationInMillis.element;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"fileDurationInMillis");
                    var18_21 = (BigDecimal)v9;
                    Intrinsics.checkNotNullExpressionValue((Object)var18_21.add(CalculateKt.calculateDurationInMillis(it, this.waveConfig)), (String)"this.add(other)");
                    fileDurationInMillis.element = fileDurationInMillis.element;
                }
                fileWriter.writeDataToStream(lastSkippedData, data);
                v10 = fileDurationInMillis.element;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"fileDurationInMillis");
                var12_15 = (BigDecimal)v10;
                Intrinsics.checkNotNullExpressionValue((Object)var12_15.add(CalculateKt.calculateDurationInMillis(data, this.waveConfig)), (String)"this.add(other)");
                fileDurationInMillis.element = fileDurationInMillis.element;
lbl148:
                // 4 sources

                $continuation.L$0 = this;
                $continuation.L$1 = data;
                $continuation.L$2 = outputStream;
                $continuation.L$3 = fileWriter;
                $continuation.L$4 = lastSkippedData;
                $continuation.L$5 = fileDurationInMillis;
                $continuation.I$0 = bufferSize;
                $continuation.I$1 = bufferSizeToKeep;
                $continuation.label = 4;
                v11 = this.updateListeners(amplitude, ((BigDecimal)fileDurationInMillis.element).longValue(), (Continuation<? super Unit>)$continuation);
                if (v11 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl172
            }
            case 4: {
                bufferSizeToKeep = $continuation.I$1;
                bufferSize = $continuation.I$0;
                fileDurationInMillis = (Ref.ObjectRef)$continuation.L$5;
                lastSkippedData = (LinkedList<float[]>)$continuation.L$4;
                fileWriter = (FileWriter)$continuation.L$3;
                outputStream = (OutputStream)$continuation.L$2;
                data = (float[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl172:
                // 2 sources

                ** continue;
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = outputStream;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.label = 5;
        v12 = this.updateState(RecorderState.STOP, (Continuation<? super Unit>)$continuation);
        if (v12 == var21_4) {
            return var21_4;
        }
        ** GOTO lbl189
        {
            case 5: {
                outputStream = (OutputStream)$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl189:
                // 2 sources

                this.cleanup(outputStream);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int getByteArrayAmplitude(byte[] data) {
        return this.onAmplitudeListener != null || this.silenceDetection ? CalculateKt.calculateAmplitude(data, this.waveConfig.getAudioEncoding()) : 0;
    }

    private final int getFloatArrayAmplitude(float[] data) {
        return this.onAmplitudeListener != null || this.silenceDetection ? CalculateKt.calculateAmplitude(data) : 0;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleByteSilenceState(int var1_1, LinkedList<byte[]> var2_2, byte[] var3_3, int var4_4, Continuation<? super Unit> var5_5) {
        block10: {
            if (!(var5_5 instanceof handleByteSilenceState.1)) ** GOTO lbl-1000
            var15_6 = var5_5;
            if ((var15_6.label & -2147483648) != 0) {
                var15_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ WaveRecorder this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return WaveRecorder.access$handleByteSilenceState(this.this$0, 0, null, null, 0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (amplitude >= this.silenceDetectionConfig.getMinAmplitudeThreshold()) break;
                    v0 = this.silenceDuration;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"silenceDuration");
                    var6_9 = v0;
                    v1 = var6_9.add(CalculateKt.calculateDurationInMillis(data, this.waveConfig));
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this.add(other)");
                    this.silenceDuration = v1;
                    if (this.silenceDuration.longValue() < this.silenceDetectionConfig.getPreSilenceDurationInMillis()) break block10;
                    if (!this.isSkipping.get()) {
                        this.isSkipping.set(true);
                        $continuation.L$0 = lastSkippedData;
                        $continuation.L$1 = data;
                        $continuation.I$0 = bufferSizeToKeep;
                        $continuation.label = 1;
                        v2 = this.updateState(RecorderState.SKIPPING_SILENCE, (Continuation<? super Unit>)$continuation);
                        if (v2 == var16_8) {
                            return var16_8;
                        }
                    }
                    ** GOTO lbl36
                }
                case 1: {
                    bufferSizeToKeep = $continuation.I$0;
                    data = (byte[])$continuation.L$1;
                    lastSkippedData = (LinkedList)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl36:
                    // 2 sources

                    v3 = Arrays.copyOf(var3_3, var3_3.length);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"copyOf(this, size)");
                    lastSkippedData.addLast(v3);
                    var6_9 = lastSkippedData;
                    var7_10 = 0;
                    var8_11 = var6_9.iterator();
                    while (var8_11.hasNext()) {
                        var9_12 = var8_11.next();
                        it = (byte[])var9_12;
                        var12_15 = var7_10;
                        $i$a$-sumOfInt-WaveRecorder$handleByteSilenceState$2 = false;
                        var13_16 = it.length;
                        var7_10 = var12_15 + var13_16;
                    }
                    if (var7_10 > bufferSizeToKeep) {
                        lastSkippedData.removeFirst();
                    }
                    break block10;
                }
            }
            this.silenceDuration = BigDecimal.ZERO;
            this.isSkipping.set(false);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleFloatSilenceState(int var1_1, LinkedList<float[]> var2_2, float[] var3_3, int var4_4, Continuation<? super Unit> var5_5) {
        block10: {
            if (!(var5_5 instanceof handleFloatSilenceState.1)) ** GOTO lbl-1000
            var15_6 = var5_5;
            if ((var15_6.label & -2147483648) != 0) {
                var15_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ WaveRecorder this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return WaveRecorder.access$handleFloatSilenceState(this.this$0, 0, null, null, 0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (amplitude >= this.silenceDetectionConfig.getMinAmplitudeThreshold()) break;
                    v0 = this.silenceDuration;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"silenceDuration");
                    var6_9 = v0;
                    v1 = var6_9.add(CalculateKt.calculateDurationInMillis(data, this.waveConfig));
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this.add(other)");
                    this.silenceDuration = v1;
                    if (this.silenceDuration.longValue() < this.silenceDetectionConfig.getPreSilenceDurationInMillis()) break block10;
                    if (!this.isSkipping.get()) {
                        this.isSkipping.set(true);
                        $continuation.L$0 = lastSkippedData;
                        $continuation.L$1 = data;
                        $continuation.I$0 = bufferSizeToKeep;
                        $continuation.label = 1;
                        v2 = this.updateState(RecorderState.SKIPPING_SILENCE, (Continuation<? super Unit>)$continuation);
                        if (v2 == var16_8) {
                            return var16_8;
                        }
                    }
                    ** GOTO lbl36
                }
                case 1: {
                    bufferSizeToKeep = $continuation.I$0;
                    data = (float[])$continuation.L$1;
                    lastSkippedData = (LinkedList)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl36:
                    // 2 sources

                    v3 = Arrays.copyOf(var3_3, var3_3.length);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"copyOf(this, size)");
                    lastSkippedData.addLast(v3);
                    var6_9 = lastSkippedData;
                    var7_10 = 0;
                    var8_11 = var6_9.iterator();
                    while (var8_11.hasNext()) {
                        var9_12 = var8_11.next();
                        it = (float[])var9_12;
                        var12_15 = var7_10;
                        $i$a$-sumOfInt-WaveRecorder$handleFloatSilenceState$2 = false;
                        var13_16 = it.length;
                        var7_10 = var12_15 + var13_16;
                    }
                    if (var7_10 > bufferSizeToKeep) {
                        lastSkippedData.removeFirst();
                    }
                    break block10;
                }
            }
            this.silenceDuration = BigDecimal.ZERO;
            this.isSkipping.set(false);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object updateListeners(int amplitude, long fileDurationInMillis, Continuation<? super Unit> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, amplitude, fileDurationInMillis, null){
            int label;
            final /* synthetic */ WaveRecorder this$0;
            final /* synthetic */ int $amplitude;
            final /* synthetic */ long $fileDurationInMillis;
            {
                this.this$0 = $receiver;
                this.$amplitude = $amplitude;
                this.$fileDurationInMillis = $fileDurationInMillis;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        Object object2;
                        ResultKt.throwOnFailure((Object)object);
                        Function1<Integer, Unit> function1 = this.this$0.getOnAmplitudeListener();
                        if (function1 != null) {
                            object2 = function1;
                            int n = this.$amplitude;
                            Function1<Integer, Unit> it = object2;
                            boolean bl = false;
                            it.invoke((Object)Boxing.boxInt((int)n));
                        }
                        Function1<Long, Unit> function12 = this.this$0.getOnTimeElapsed();
                        if (function12 != null) {
                            object2 = function12;
                            long l = this.$fileDurationInMillis;
                            Object it = object2;
                            boolean bl = false;
                            it.invoke((Object)Boxing.boxLong((long)TimeUnit.MILLISECONDS.toSeconds(l)));
                        }
                        Function1<Long, Unit> function13 = this.this$0.getOnTimeElapsedInMillis();
                        if (function13 != null) {
                            object2 = function13;
                            long l = this.$fileDurationInMillis;
                            Object it = object2;
                            boolean bl = false;
                            it.invoke((Object)Boxing.boxLong((long)l));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object updateState(RecorderState state, Continuation<? super Unit> $completion) {
        if (this.currentState != state) {
            this.currentState = state;
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
                int label;
                final /* synthetic */ WaveRecorder this$0;
                final /* synthetic */ RecorderState $state;
                {
                    this.this$0 = $receiver;
                    this.$state = $state;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Unit unit;
                            ResultKt.throwOnFailure((Object)object);
                            Function1<RecorderState, Unit> function1 = this.this$0.getOnStateChangeListener();
                            if (function1 != null) {
                                Function1<RecorderState, Unit> function12 = function1;
                                RecorderState recorderState = this.$state;
                                Function1<RecorderState, Unit> it = function12;
                                boolean bl = false;
                                it.invoke((Object)((Object)recorderState));
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            return unit;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }
        return Unit.INSTANCE;
    }

    private final void cleanup(OutputStream outputStream) {
        block0: {
            outputStream.close();
            NoiseSuppressor noiseSuppressor = this.noiseSuppressor;
            if (noiseSuppressor == null) break block0;
            noiseSuppressor.release();
        }
    }

    public final void changeFilePath(@NotNull String newFilePath) {
        Intrinsics.checkNotNullParameter((Object)newFilePath, (String)"newFilePath");
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord = null;
        }
        if (audioRecord.getRecordingState() == 3) {
            throw new IllegalStateException("Cannot change filePath when still recording.");
        }
        this.filePath = newFilePath;
    }

    public final void changeFilePath(@NotNull Uri newFileUri) {
        Intrinsics.checkNotNullParameter((Object)newFileUri, (String)"newFileUri");
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord = null;
        }
        if (audioRecord.getRecordingState() == 3) {
            throw new IllegalStateException("Cannot change filePath when still recording.");
        }
        this.fileUri = newFileUri;
    }

    public final void stopRecording() {
        if (this.isAudioRecorderInitialized()) {
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                audioRecord = null;
            }
            audioRecord.stop();
            AudioRecord audioRecord2 = this.audioRecorder;
            if (audioRecord2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                audioRecord2 = null;
            }
            audioRecord2.release();
            this.isPaused.set(false);
            this.isSkipping.set(false);
            this.silenceDuration = BigDecimal.ZERO;
            this.audioSessionId = -1;
            if (this.fileUri != null) {
                Uri uri = this.fileUri;
                Intrinsics.checkNotNull((Object)uri);
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    context = null;
                }
                new WaveHeaderWriter(uri, context, this.waveConfig).writeHeader();
            } else {
                String string = this.filePath;
                Intrinsics.checkNotNull((Object)string);
                new WaveHeaderWriter(string, this.waveConfig).writeHeader();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioRecorderInitialized() {
        if (this.audioRecorder == null) return false;
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord = null;
        }
        if (audioRecord.getState() != 1) return false;
        return true;
    }

    public final void pauseRecording() {
        this.isPaused.set(true);
    }

    public final void resumeRecording() {
        this.silenceDuration = BigDecimal.ZERO;
        this.isSkipping.set(false);
        this.isPaused.set(false);
    }

    public static final /* synthetic */ Object access$writeFloatAudioDataToStorage(WaveRecorder $this, Continuation $completion) {
        return $this.writeFloatAudioDataToStorage((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$writeByteAudioDataToStorage(WaveRecorder $this, Continuation $completion) {
        return $this.writeByteAudioDataToStorage((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleByteSilenceState(WaveRecorder $this, int amplitude, LinkedList lastSkippedData, byte[] data, int bufferSizeToKeep, Continuation $completion) {
        return $this.handleByteSilenceState(amplitude, lastSkippedData, data, bufferSizeToKeep, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleFloatSilenceState(WaveRecorder $this, int amplitude, LinkedList lastSkippedData, float[] data, int bufferSizeToKeep, Continuation $completion) {
        return $this.handleFloatSilenceState(amplitude, lastSkippedData, data, bufferSizeToKeep, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateListeners(WaveRecorder $this, int amplitude, long fileDurationInMillis, Continuation $completion) {
        return $this.updateListeners(amplitude, fileDurationInMillis, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateState(WaveRecorder $this, RecorderState state, Continuation $completion) {
        return $this.updateState(state, (Continuation<? super Unit>)$completion);
    }
}

